(function (ImageViewer, dependencies, components) {
'use strict';

var $ = dependencies.jQuery;
var utils = ImageViewer.utils;

ImageViewer.dialog.viewerWeb = function (config) {
    var options = {
        name: 'viewer_web',
        template: '#rong-template-viewer_web',
        data: function () {
            return {
                show: true,
                isMaxWindow: false,
                imageList: [],
                selectIndex: 0,
                tip: '',
                lan: 'zh',
                fileToken: ''
            };
        },
        components: {
            imageViewer: components.getImageViewer
        },
        mounted: function () {
            var context = this;
            if (context.$refs.viewer) {
                context.$refs.viewer.onUpdate(config);
            } else {
                setTimeout(function () {
                    context.$refs.viewer.onUpdate(config);
                }, 300);
            }
        },
        methods: {
            close: function () {
                this.show = false;
            }
        }
    };
    mountDialog(options, function (instance) {
        ImageViewer._viewerWeb = instance;
    });
};

function mountDialog(options, callback) {
    var templateSrc = options.template;
    if (mountDialog[templateSrc] === 'busy') {
        return;
    }
    mountDialog[templateSrc] = 'busy';
    var promise = utils.loadTemplate(options.template);
    promise.then(function (html) {
        $.extend(options, { template: html });
        options.mixins = options.mixins || [];
        var locale = {
            mounted: function () {
                var im = dependencies.RongIM.instance;
                var context = this;
                context.imLogouted = function () {
                    context.$destroy();
                    $(context.$el).remove();
                    im.$off('imLogouted', context.imLogouted);
                };
                watchHideDialog(context);
                im.$on('imLogouted', context.imLogouted);
            },
            computed: {
                locale: function () {
                    var localeAttr = dependencies.RongIM.instance.locale;
                    var name = utils.kebabToCamel(options.name);
                    return $.extend(true, {}, localeAttr, localeAttr.components[name]);
                }
            },
            methods: {
                localeFormat: utils.templateFormat
            }
        };
        options.mixins.push(locale);

        var Dialog = Vue.extend(options);
        var instance = new Dialog({
            el: document.createElement('div')
        });
        var wrap = dependencies.RongIM.instance.$el.firstChild;
        $(wrap).append(instance.$el);
        if ($.isFunction(callback)) callback(instance);
    }).always(function () {
        delete mountDialog[templateSrc];
    });
}

function watchHideDialog(context) {
    window.onhashchange = function () {
        context.close();
    };
}
}(ImageViewer, {
    jQuery: jQuery,
    RongIM: RongIM
}, ImageViewer.components));
