(function (ImageViewer) {
'use strict';

var noop = function () {};

ImageViewer.browserWindow = {
    max: noop,
    min: noop,
    restore: noop,
    close: noop,
    setMinimumSize: noop,
    setFullScreen: noop,
    center: noop
};

ImageViewer.system = {
    platform: 'web',
    getWorkAreaSize: function () {
        return { width: window.screen.availWidth, height: window.screen.availHeight };
    }
};

var _download = function (url) {
    var a = document.createElement('A');
    a.href = url;
    a.download = url.substr(url.lastIndexOf('/') + 1);
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
};

var download = function (file) {
    return {
        start: function () {
            _download(file.url);
        },
        pause: noop,
        resume: function () {
            _download(file.url);
        },
        abort: noop,
        save: function () {
            _download(file.url);
        },
        saveAs: function () {
            _download(file.url);
        },
        onError: noop,
        onReady: noop,
        onProgress: noop,
        onComplete: noop,
        onCancel: noop
    };
};
ImageViewer.download = download;

function Download(data) {
    this.data = data;
}
var DownloadPublic = {
    onError: $.noop,
    onComplete: $.noop,
    onCancel: $.noop,
    saveAs: function () {
        // console.log('download', arguments);
        var aEl = document.createElement('a');
        aEl.target = '_blank';
        aEl.href = this.data.url;
        aEl.download = '';
        document.body.appendChild(aEl);
        aEl.click();
        $(aEl).remove();
        this.onComplete();
    }
};
$.extend(Download.prototype, DownloadPublic);

ImageViewer.download = function (data) {
    return new Download(data);
};
}(ImageViewer));
