(function (RongIM, dependencies, components) {
    'use strict';
    // 1. 新增：引入和 addReceivers 一致的 common 依赖（关键）
    var common = RongIM.common;
    var $ = dependencies.jQuery; // 新增：如果需要操作DOM，引入jQuery
    var utils = RongIM.utils;
    var debounceResume = utils.debounce(resumeUpload, 200);
    
    components.addAttachment = function (resolve, reject) {
        var im = RongIM.instance;
        var options = {
            name: 'add-attachment',
            template: 'modules/pin/templates/add-attachment.html',
            props: {
                attachs: {
                    type: Array,
                    default: []
                },
                isAttachFull: false
            },
            data: function () {
                return {
                    attachments: [...this.attachs] || [],
                };
            },
            computed: {
                getAttachCount: function () {
                    var count = this.attachments.length;
                    var attachFormat = im.locale.components.newPin.attaCount;
                    return this.localeFormat(attachFormat, count);
                },
                isShowRenew: function () {
                    return im.status === utils.status.CONNECTED;
                },
                isWeb: function () {
                    var platform = utils.getPlatform();
                    var isWeb = platform.indexOf('web') !== -1;
                    return isWeb;
                }
            },
            watch: {},
            mounted() {
                console.log(this.attachments)
                if (this.attachments.length > 0) {
                    this.getAttachs()
                }
            },
            methods: {
                // ========== 核心新增：加入和 addReceivers 一致的 toast/toastError 方法 ==========
                toastError: function (errorCode) {
                    common.toastError(errorCode, this.$el.firstChild);
                },
                toast: function (params) {
                    params.el = this.$el.firstChild; // 必须传递DOM上下文，和addReceivers保持一致
                    common.messageToast(params);
                },
                // ========== 原有方法保留，仅修正 toast 调用（已兼容） ==========
                getAttachs: function () {
                    let list = this.attachments
                    this.attachments = list.map(e => {
                        return {
                            data: e,
                            progress: 100,
                            url: e.url,
                            rawSize: e.size,
                            uploadStatus: utils.uploadStatus.SUCCESS
                        };
                    });
                },
                clickButton: function () {
                    $('#rongAddAttachment').trigger("change");
                },
                addAttachment: function (event) {
                    var context = this;
                    var fileSize = RongIM.serverConfig.media.max_file_size * 1024 * 1024;
                    var fileMaxSize = fileSize ? utils.formatFileSize(fileSize) : '';
                    var message = fileMaxSize ? utils.templateFormat(context.locale.tips.overSize, fileMaxSize) : '';
                    var fileList = event.target.files;
                    if (!checkAttachInBound(context, fileList)) {
                        // 调用新增的 toast 方法（现在可用）
                        context.toast({
                            type: 'error',
                            message: context.locale.components.newPin.mostAtta
                        });
                        return;
                    }
                    var sizeState = checkAttachSize(fileList, fileSize);
                    if (sizeState === 1 || sizeState === 2) {
                        var showMsg = sizeState === 1 ? context.locale.tips.zeroSize : message;
                        // 调用新增的 toast 方法（现在可用）
                        this.toast({
                            type: 'error',
                            message: showMsg
                        });
                    }
                    var uploadCount = 0;
                    for (var i = 0; i < fileList.length; i += 1) {
                        var file = fileList[i];
                        if (file.size > 0 && file.size <= fileSize) {
                            upload(file, context,this),
                            uploadCount += 1;
                        }
                        context.$emit('updateAttachs', context.attachments)
                    }
                    if (uploadCount === 0) {
                        return;
                    }
                    this.showAttach = true;
                    components.addAttachment(context);
                    resetInputFileValue('rongAddAttachmentInDetail');
                    
                },
                formatFileSize: utils.formatFileSize,
                isShowProgress: function (attach) {
                    var isCanceled = attach.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isUploading = attach.uploadStatus === utils.uploadStatus.UPLOADING;
                    return isCanceled || isUploading;
                },
                getProgress: function (attach) {
                    return parseInt(attach.progress) + '%';
                },
                getFileIconClass: function (data) {
                    let name = data.name || data.data.name
                    var prefix = 'rong-pin-file-';
                    var getPointTotal = name.split('.').length - 1;
                    var splitArr = name.split('.');
                    var isExpired = false;
                    var suffix = '';
                    if (isExpired) {
                        suffix = '-expired';
                    }
                    return prefix + splitArr[getPointTotal] + suffix;
                },
                getProgressWidth: function (attach) {
                    attach.progress = attach.progress || 0;
                    return attach.progress + '%';
                },
                removeAttachment: function (attachment, index) {
                    this.attachments.splice(index, 1)
                    this.$emit("removeAttachment", this.attachments)
                },
                getAttachName: function (data) {
                    let name = data.name || data.data.name;
                    return name;
                },
                cancelUpload: function (item) {
                    item.cancel();
                    if (this.isWeb) {
                        this.removeAttachment(item);
                    }
                },
                isCancelUpload: function (item) {
                    var isCanceled = item.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isFailed = item.uploadStatus === utils.uploadStatus.FAIL;
                    return isCanceled || isFailed;
                },
                resumeUpload: function (item) {
                    if (item.uploadStatus === utils.uploadStatus.UPLOADING) {
                        return;
                    }
                    if (!checkExist(item, this)) {
                        return;
                    }
                    debounceResume(item);
                },
                isShowCancel: function (item) {
                    return item.uploadStatus === utils.uploadStatus.UPLOADING;
                },
                isShowRemove: function (item) {
                    var isCanceled = item.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isComplete = item.uploadStatus === utils.uploadStatus.SUCCESS;
                    return isCanceled || isComplete;
                },
                fileState: function (item) {
                    var state = '';
                    switch (item.uploadStatus) {
                        case utils.uploadStatus.READY:
                            break;
                        case utils.uploadStatus.UPLOADING:
                            state = this.locale.uploading;
                            break;
                        case utils.uploadStatus.SUCCESS:
                            state = this.locale.uploaded;
                            break;
                        case utils.uploadStatus.FAIL:
                            state = this.locale.cancelled;
                            break;
                        case utils.uploadStatus.CANCELLED:
                            state = this.locale.stoped;
                            break;
                        case utils.uploadStatus.EXPIRED:
                            state = this.locale.expired;
                            break;
                        default:
                            state = this.locale.uploaded;
                            break;
                    }
                    return state;
                },
                isAssetTypeAnImage: function (name) {
                    if(name==undefined){
                        return false;
                    }
                    let index = name.lastIndexOf(".");
                    return utils.isAssetTypeAnImage(name.substr(index + 1))
                },
                getUrl(item){
                   return item.url || item.data.path
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function resumeUpload(attach) {
        var dataModel = RongIM.instance.dataModel;
        var getFileType = utils.getFileType;
        var fileType = getFileType(attach.data.name);
        var pinApi = dataModel.Pin;
        pinApi.uploadAttach(fileType, attach.data, attach, function (err) {
            if (err) {
                utils.console.warn('上传失败');
            }
        });
    }

    function watchAttach(addPin) {
        var fileTimer = addPin.fileTimer;
        if (fileTimer) clearInterval(fileTimer);
        fileTimer = setInterval(function () {
            var attachments = addPin.attachments.filter(function (attachment) {
                return attachment.uploadStatus === utils.uploadStatus.UPLOADING;
            });
            for (var i = 0; i < attachments.length; i += 1) {
                var item = attachments[i];
                checkExist(item, addPin);
            }
        }, 6000);
    }

    function checkExist(item, addPin) {
        var file = RongIM.file;
        var localPath = item.data.path;
        var fileExist = file.checkExist(localPath);
        if (!fileExist) {
            // 修正：调用新增的 toastError 方法（和addReceivers一致）
            addPin.toastError('file-404');
            addPin.cancelUpload(item);
            return false;
        }
        return true;
    }

    function resetInputFileValue(inputId) {
        var $inputFile = $('#' + inputId);
        $inputFile.val('');
    }

    function checkAttachInBound(context, fileList) {
        var serverConfig = RongIM.serverConfig;
        var maxAttachCount = serverConfig.pin.max_attachment_count;
        var attachCount = context.attachments.length + fileList.length;
        var isBeyond = attachCount > maxAttachCount;
        return !isBeyond;
    }

    function checkAttachSize(fileList, fileSize) {
        var hasZero = 0;
        for (var key in fileList) {
            if (fileList[key].size === 0) {
                hasZero = 1;
                break;
            }
            if (fileList[key].size > fileSize) {
                hasZero = 2;
                break;
            }
        }
        return hasZero;
    }

    function upload(file, context, vm) {
        // 1. 敏感词配置
        var sensitiveWordsStr = vm.locale.components.login.pin_safe_tips;
        var sensitiveWords = sensitiveWordsStr 
            ? sensitiveWordsStr.split(',').filter(word => word.trim() !== '') 
            : ['秘密', '机密', '内部'];

        // 支持检测的文件类型：仅保留txt和docx
        var supportCheckTypes = ['txt', 'docx'];

        // 2. 获取文件后缀和原始文件名（保留原始名称用于提示，避免小写混淆）
        var originalFileName = file.name; // 原始文件名（带后缀，不转小写）
        var fileName = originalFileName.toLowerCase(); // 小写文件名，用于后缀判断
        var fileExt = fileName.split('.').pop();

        // ========== 新增：文件名敏感词检测（核心修改） ==========
        function checkFileNameSensitive() {
            var matchedWords = [];
            sensitiveWords.forEach(word => {
                // 正则不区分大小写，匹配原始文件名中的敏感词
                var regex = new RegExp(word.trim(), 'gi');
                if (regex.test(originalFileName)) {
                    matchedWords.push(word.trim());
                }
            });

            if (matchedWords.length > 0) {
               //  window.alert('文件名包含敏感信息：' + matchedWords.join('、'));
                vm.toast({
                    type: 'error',
                    //message: '文件名包含敏感信息：' + matchedWords.join('、') + '（文件名：' + originalFileName + '）'
                    message: '文件名包含敏感信息：' + matchedWords.join('、')
                });
            }
        }
        // 先执行文件名检测（无论文件类型是否支持内容检测，都检测文件名）
        checkFileNameSensitive();

        // 3. 构建附件对象
        var models = RongIM.instance.dataModel;
        var pin = models.Pin;
        var getFileType = utils.getFileType;
        var fileType = getFileType(file.name);
        var attach = {
            data: file,
            progress: 0,
            url: null,
            uploadId: Date.now(),
            uploadStatus: utils.uploadStatus.READY,
            rawSize: file.size
        };

        // 4. 敏感词检测逻辑（原有内容检测逻辑保留，新增文件名检测后不影响）
        if (supportCheckTypes.indexOf(fileExt) > -1) {
            var reader = new FileReader();
            reader.onload = function (e) {
                var content = '';
                try {
                    if (fileExt === 'txt') {
                        content = e.target.result;
                        checkSensitive(content);
                    } else if (fileExt === 'docx') {
                        if (window.mammoth) {
                            mammoth.extractRawText({ arrayBuffer: e.target.result })
                                .then(function (result) {
                                    content = result.value;
                                    checkSensitive(content);
                                })
                                .catch(function (err) {
                                    utils.console.warn('DOCX解析失败，跳过敏感词检测:', err);
                                    continueUpload();
                                });
                        } else {
                            utils.console.warn('未加载mammoth.js，跳过敏感词检测');
                            continueUpload();
                        }
                    }
                } catch (err) {
                    utils.console.warn('文件解析异常:', err);
                    continueUpload();
                }
            };

            reader.onerror = function (err) {
                utils.console.warn('文件读取失败:', err);
                continueUpload();
            };

            if (fileExt === 'txt') {
                reader.readAsText(file);
            } else if (fileExt === 'docx') {
                reader.readAsArrayBuffer(file);
            }

            function checkSensitive(content) {
                var matchedWords = [];
                sensitiveWords.forEach(word => {
                    var regex = new RegExp(word.trim(), 'gi');
                    if (regex.test(content)) {
                        matchedWords.push(word.trim());
                    }
                });

                if (matchedWords.length > 0) {
                    //window.alert('文件内容包含敏感信息：' + matchedWords.join('、'));
                    vm.toast({
                        type: 'error',
                        // 提示信息区分“文件内容”，并标注文件名
                        //message: '文件内容包含敏感信息：' + matchedWords.join('、') + '（文件名：' + originalFileName + '）'
                        message: '文件内容包含敏感信息：' + matchedWords.join('、')
                    });
                }
                continueUpload();
            }

            function continueUpload() {
                context.attachments.push(attach);
                pin.uploadAttach(fileType, file, attach, function (err) {
                    if (err) {
                        utils.console.warn('上传失败');
                        return;
                    }
                    saveLocalAttach(attach.data, attach.data.path);
                });
            }
        } else {
            utils.console.warn(`不支持${fileExt}格式的敏感词检测，直接上传`);
            // 非支持类型：仅检测了文件名（已在上方执行），直接上传
            context.attachments.push(attach);
            pin.uploadAttach(fileType, file, attach, function (err) {
                if (err) {
                    utils.console.warn('上传失败');
                    return;
                }
                saveLocalAttach(attach.data, attach.data.path);
            });
        }
    }

    function getNameLength(name) {
        var mark = 0;
        for (var i = 0; i < name.length; i += 1) {
            var cName = name[i];
            mark += utils.isChinese(cName) ? 2 : 1;
        }
        return mark;
    }

    function saveLocalAttach(attach, localPath) {
        var im = RongIM.instance;
        im.dataModel.Pin.addPinLocalAttach(attach.name, localPath);
    }
}(RongIM, {
    // 新增：传入jQuery依赖（和addReceivers一致）
    jQuery: jQuery
}, RongIM.components));