(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var $ = dependencies.jQuery;
    var common = RongIM.common;
    var fileApi = RongIM.dataModel.File;
    var debounceDownload = utils.debounce(initDownload, 300);

    function getAllPins(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        var system = RongIM.system;
        var options = {
            name: 'pin-allPins',
            template: 'modules/pin/templates/allpins.html',
            data: function () {
                return {
                    show: true,
                    confirmExpand: false,
                    pinList: [],
                    // receivedList: [], //我收到的列表
                    // sentList: [], //我发出的列表
                    minTimestamp: 0,
                    hasMore: true,
                    selectedPin: null,
                    isClicking: 0,
                    isLoading: false,
                    searchText: '',
                    ifList: true, //是否显示list模式
                    downloaders: {},
                    attachmentList: [],
                    // startDate: '', //开始时间
                    // endDate: '', //结束时间
                    searchObj: {
                        start: '',
                        end: '',
                        contacts: '',
                        title: '',
                        attachedName: '',
                        content: ''
                    },
                    receivedUnReadCount: {
                        unConfirm: 0,
                        unComment: 0
                    },
                    isSender: true,
                    ifSearch: false,
                    ifShowDetail: false,
                    ifHight: false,
                    higtStyle: {
                        height: 'calc(100% - 100px)',
                        // overflowY: 'auto'
                    },
                    pinCount: 0, //寻呼数量
                    contentHeight: {
                        height: 'calc(100vh - 130px)',
                    },
                    contentHeightMac: {
                        height: 'calc(100vh - 120px)',
                    },
                    totalPinCount: 0,
                    lightSearchObj: {},
                    showSetting: false,
                    currentNum: 0,
                    currentIndex: 0
                };
            },
            components: {
                avatar: components.getAvatar,
                pinDetail: components.getPinDetail,
                status: components.getStatus,
                pinSearch: components.getPinSearch,
                pinAlarmClock: components.getAlarmClock
            },
            mixins: [getContextMenu()],
            computed: {
                // 系统是否为win32或者linux
                os: function () {
                    return system.platform === 'win32' || system.platform === 'linux';
                },
                showEmptyPage: function () {
                    return this.pinList.length === 0;
                },
                isConnected: function () {
                    return im.status === utils.status.CONNECTED;
                },
                isWeb: function () {
                    var platform = utils.getPlatform();
                    var isWeb = platform.indexOf('web') !== -1;
                    return isWeb;
                },
                pinDetailStyle: function () {
                    if (!this.os) return {};
                    return { top: '30px' };
                }
            },
            methods: getMethods(im, dataModel),
            mounted: function () {
                mounted(this, dataModel, im);
            },
            watch: {
                ifHight(v) {
                    if (v) {
                        this.contentHeight.height = 'calc(100vh - 335px)'
                    } else {
                        this.contentHeight.height = 'calc(100vh - 130px)'
                    }

                }
            },
            destroyed: function () {
                pinApi.unwatch(this.pinCreateWatch);
                pinApi.unwatch(this.pinChangeWatch);
                pinApi.unwatch(this.pinDeleteWatch);
                im.$off('createPin')

            },

        };
        utils.asyncComponent(options, resolve, reject);
    }

    function mounted(context, dataModel, im) {
        var pinApi = dataModel.Pin;
        // initDate(context);

        pinCreateWatch(context, pinApi);
        pinChangeWatch(context, pinApi);
        pinDeleteWatch(context, pinApi);
        watchDeletePin(context);
        watchConnectStatus(context, pinApi);
        setupReceivedUnReadCount(context, pinApi)
        //搜索全部
        let searchText = localStorage.getItem('searchText')
        let searchObj = localStorage.getItem('searchObj')
        if (searchText && searchText != '') {
            context.searchPin(searchText)
        } else if (searchObj && searchObj !== '{}') {
            context.searchObj = JSON.parse(searchObj)
            context.searchHigtPin()
        } else {
            initPinAll(context, pinApi);
        }
        im.$on('createPin', function (data) {
            let list = context.pinList.concat([])
            if (data.delayed) {
                data.user = im.loginUser
            }
            list.unshift(data)
            context.pinList = list
        })
        im.$off('searchPin')
        //监听搜索
        im.$on('searchPin', (data) => {

            context.hasMore = true
            context.minTimestamp = 0
            context.pinList = []
            if (data.isHigh) { //高级搜索
                context.higtStyle.height = 'calc(100% - 310px)'
                context.searchObj = data.data
                context.ifHight = data.isHigh;
                if (data.data) {
                    context.ifSearch = true
                    context.searchHigtPin()
                } else {
                    context.ifSearch = false
                    initPinAll(context, pinApi);
                }
            } else {
                //模糊搜索
                context.higtStyle.height = 'calc(100% - 100px)'
                context.searchText = data.data || ''
                context.ifHight = false;
                if (data.data && data.data != '') {
                    context.searchPin(data.data)
                    context.ifSearch = true
                } else {
                    context.ifSearch = false
                    initPinAll(context, pinApi);
                }
            }
            // im.$off('searchPin')
        })
    }

    function initPinAll(context, pinApi) {
        var loadMore = function () {
            Vue.nextTick(function () {
                if (isScrollToBottom()) setupPinAll(context, pinApi, context.minTimestamp, loadMore);
            });
        };
        setupPinAll(context, pinApi, context.minTimestamp, loadMore);
    }
    // 获取为确认条数
    function setupReceivedUnReadCount(context, pinApi) {
        pinApi.getInboxUnRead(function (errorCode, unread) {
            if (!errorCode && unread) {
                context.receivedUnReadCount.unComment = unread.length;
            }
        });
    }

    function getMethods(im, dataModel) {
        var pinApi = dataModel.Pin;
        return {
            formatFileSize: utils.formatFileSize,
            //时间戳转化
            formatDate: function (value) { //value为13位的时间戳
                return moment(value).format('YYYY-MM-DD HH:mm:ss');
            },
            status: function () {
                return im.status;
            },
            //寻呼主题
            getPinTitle: function (pin) {
                if (!pin || !pin.title) {
                    return undefined;
                }
                var title = common.textMessageFormat(pin.title);
                let text = ''
                if (this.ifHight) {
                    text = this.lightSearchObj ? this.lightSearchObj.title : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(title, text);
            },
            //寻呼内容
            getPinContent: function (pin) {
                if (!pin || !pin.content) {
                    return undefined;
                }
                var content = common.textMessageFormat(pin.content);
                let text = ''
                if (this.ifHight) {
                    text = this.lightSearchObj ? this.lightSearchObj.content : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(content, text);
            },
            //寻呼附件名称
            getAttachName: function (attach) {
                if (!attach || !attach.name) {
                    return undefined;
                }
                var name = common.textMessageFormat(attach.name);
                let text = ''
                if (this.ifHight) {
                    text = this.lightSearchObj ? this.lightSearchObj.attachedName : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(name, text);
            },
            //获取接收人
            getReceiverName: function (pin) {
                if (!pin || !pin.receiver_name) {
                    return undefined;
                }
                var name = common.textMessageFormat(pin.receiver_name);
                let text = ''
                if (this.ifHight) {
                    text = this.lightSearchObj ? this.lightSearchObj.contacts : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(name, text);
            },
            userProfile: function (userId) {
                var that = this;
                this.isClicking++;
                dialog.user(userId, function () {
                    that.isClicking--;
                });
            },
            getUsername: function (pin) {
                let name = ''
                //收到的寻呼
                if (pin.type === 1) {
                    name = pin.user ? pin.user.alias || pin.user.name : ' '
                } else {
                    //发出的寻呼
                    name = pin.receiver_name
                }
                var textName = common.textMessageFormat(name);
                let text = ''
                if (this.ifHight) {
                    text = this.lightSearchObj ? this.lightSearchObj.contacts : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(textName, text);
                // return name;
            },
            getConfirmStr: function (pin) {
                var localeReceived = im.locale.components.receivedPin;
                return pin.confirmed ? localeReceived.replyNone : localeReceived.unConfirmed;
            },
            getUnConfirmStr: function (pin) {
                let localeSendPin = im.locale.components.sendPin;
                if (pin.un_confirm_count) {
                    return this.localeFormat(localeSendPin.unConfirmed, pin.un_confirm_count);
                } else {
                    return im.locale.components.pinDetail.allConfirmed;
                }
            },
            getReplyDetail: function (pin) {
                var localeReceived = im.locale.components.receivedPin;
                var replyPrompt = this.localeFormat(localeReceived.reply, pin.comment_count);
                replyPrompt = pin.comment_count ? replyPrompt : localeReceived.replyNone;
                return pin.confirmed ? replyPrompt : localeReceived.confirmReceived;
            },
            dateFormat: function (pin) {
                let timestamp = 0
                //我发出的
                if (pin.type == 0) {
                    //定时发送
                    // if (pin.delayed) {
                    //     timestamp = pin.create_dt
                    // } else {
                    //立即发送
                    timestamp = pin.create_dt
                    // }
                } else {
                    //我收到的
                    timestamp = pin.send_dt || pin.create_dt
                }
                var dateFormat = utils.dateFormat;
                var options = {
                    alwaysShowTime: true
                };
                return dateFormat(timestamp, options);
            },
            showDetail: function (pin, isReply) {
                let _that = this
                if (pin.title !== '已撤回') {
                    // setupPinDetail(_that, pinApi, pin, function (selectPin) {
                    if (!_that.isClicking) {
                        _that.selectedPin = pin;
                        _that.ifShowDetail = true
                        _that.selectedPin.isReply = isReply;
                        pin.un_read_comment_count = 0;
                        if (_that.selectedPin.type == 1) {
                            _that.isSender = false
                        } else {
                            _that.isSender = true
                        }
                    }
                    // });

                } else {
                    common.messageToast({
                        type: 'success',
                        message: im.locale.pin.revokePin
                    });
                }

            },
            receiveConfirm: function (pin) {
                if (pin.confirmed) {
                    this.showDetail(pin, true);
                    return;
                }
                var that = this;
                this.isClicking++;
                $.when(setPinConfirm(pin, pinApi))
                    .then(function () {
                        // server 会下发通知消息屏蔽这里重复获取
                        // pinApi.notifyUnReadCount(pin.pinUid);
                    }).fail(function (err) {
                        that.toastError(err);
                    }).always(function () {
                        that.isClicking--;
                    });
            },
            closeDetail: function () {
                this.ifShowDetail = false;
                this.forwardPin(this.selectedPin)
            },
            forwardPin: function (pin) {
                let _that = this
                // setupPinDetail(_that, pinApi, pin, function (selectPin) {
                //     let msg = {
                //         forWard: true,
                //         pin: selectPin
                //     }
                //     dialog.addPin(msg);

                // });
                let msg = {
                    forWard: true,
                    pin: pin
                }
                dialog.addPin(msg);

            },
            // 撤回寻呼
            revokePin: function (pin) {
                let param = {
                    pin_uid: pin.uid,
                    uid: pin.creator_uid
                }
                let that = this;
                //判断对否在5分钟内
                let thisTime = new Date().getTime()
                let difference = 5 * 1000 * 60
                if (thisTime - pin.create_dt > difference) {
                    common.messagebox({
                        message: '已超过5分钟，请联系管理员进行撤回，电话010-68587825 内线 38681',
                        type: 'confirm',
                    });
                    return false;
                } else
                    if (pin.un_confirm_count < pin.receiver_count) {
                        common.messagebox({
                            message: '该寻呼已被' + (pin.receiver_count - pin.un_confirm_count) + '人确认，请联系管理员进行撤回，电话010-68587825 内线 38681',
                            type: 'confirm',
                        });
                        return false;
                    }


                common.messagebox({
                    message: '确定撤回该条寻呼吗？',
                    type: 'confirm',
                    callback: function () {
                        pinApi.revokePin(param, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            common.messageToast({
                                type: 'success',
                                message: "撤回成功"
                            });
                            pin.title = '已撤回'
                        })
                    }
                });

            },
            close: function () {
                this.show = false;
            },
            hasUnReadComment: function (pin) {
                var isConfirmed = pin.confirmed;
                var isSelected = this.selectedPin === pin;
                return pin.un_read_comment_count && !isSelected && isConfirmed;
            },
            afterEnter: function () {
                this.isClicking = 0;
                im.$emit('pinDetailLoadDone');
            },
            enterCancelled: function () {
                this.isClicking = 0;
            },
            scroll: function () {
                var that = this;
                if (that.ifSearch) {
                    if (that.ifHight && isScrollToBottom()) {
                        //高级搜索
                        that.searchHigtPin()
                    } else if (!that.ifHight && isScrollToBottom()) {
                        //模糊搜索
                        setupPinAllSearch(this, pinApi, that.minTimestamp)
                    }
                } else {
                    if (isScrollToBottom()) setupPinAll(this, pinApi, that.minTimestamp);
                }


            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            //高级搜索
            async searchHigtPin() {
                this.lightSearchObj = utils.deepClone(this.searchObj)
                let _that = this
                var loadMore = function () {
                    Vue.nextTick(function () {
                        if (isScrollToBottom()) allPcAccurateSearch(_that, pinApi, _that.minTimestamp, loadMore);
                    });
                };
                allPcAccurateSearch(_that, pinApi, _that.minTimestamp, loadMore)

            },
            //模糊搜索
            searchPin: function (opt) {
                this.searchText = opt;
                var loadMore = function () {
                    Vue.nextTick(function () {
                        if (isScrollToBottom()) setupPinAllSearch(this, pinApi, this.minTimestamp, loadMore);
                    });
                };
                setupPinAllSearch(this, pinApi, this.minTimestamp, loadMore);

            },
            getFileIconClass: function (name) {
                var prefix = 'rong-pin-file-';
                var getPointTotal = name.split('.').length - 1;
                var splitArr = name.split('.');
                return prefix + splitArr[getPointTotal];
            },
            clipboard: function (text, event) {
                const clipboard = new ClipboardJS(event.target, {
                    text: () => text
                })
                let that = this;
                clipboard.on('success', (e) => {
                    clipboard.destroy()
                    common.messageToast({
                        type: 'success',
                        message: that.locale.copyFileUrl.success
                    });
                })
                clipboard.on('error', (e) => {
                    clipboard.destroy()
                    common.messageToast({
                        type: 'error',
                        message: that.locale.copyFileUrl.error
                    });
                })
                clipboard.onClick(event)
            },
            // click copy content
            copy: function (attach, event) {

                let code = utils.encryptCode(url);
                // url = "https://work.cast.org.cn/modules/redirect.html?down=" + encodeURIComponent(code)
                console.log(url)
                this.clipboard(url, event);
            },
            /**
             * 字符串指定位置插入
             * @param {String} soure  原字符串
             * @param {Number} start  将要插入得位置
             * @param {String} newStr 要插入的字符
             */
            insertStr(soure, start, newStr) {
                return soure.slice(0, start) + newStr + soure.slice(start);
            },


            download: function (attach, list, index, num, isResume) {
                let count = attach.name.lastIndexOf(".");
                attach.rename = this.insertStr(attach.name, count, '_' + attach.uid);
                // attach.rename = attach.name
                console.log("attach.rename", attach.name);

                if (isResume) {
                    if (this.downloader) {
                        this.pinList[index].attachments[num].isDownloading = true;
                        this.pinList[index].attachments[num].isCanceled = false;
                        this.downloader.resume();
                    }
                    return;
                }
                let locaPath = RongIM.downloader.getSaveFolder();
                if (!locaPath) {
                    debounceDownload(attach, list, index, num, this, isResume);
                    return
                };

                RongIM.downloader.doesItExistLocaPath(locaPath).then((res) => {
                    let isFile = RongIM.downloader.getFileList(locaPath).some((item) => {
                        return attach.name == item;
                    })
                    if (isFile) {
                        this.repeatFile(locaPath, attach, list, index, num);
                    } else {
                        debounceDownload(attach, list, index, num, this, isResume);
                    }
                }).catch(err => {
                    RongIM.downloader.removeSaveFolder();
                    debounceDownload(attach, list, index, num, this, isResume);
                })
            },
            // 重复文件处理
            repeatFile(locaPath, attach, list, index, num, isResume) {
                let count = attach.name.lastIndexOf(".");
                for (let i = 1; i < RongIM.downloader.getFileList(locaPath).length; i++) {
                    if (RongIM.downloader.getFileList(locaPath).indexOf(this.insertStr(attach.name, count, "(" + i + ")")) == -1) {
                        let name = this.insertStr(attach.name, count, "(" + i + ")");
                        i = RongIM.downloader.getFileList(locaPath).length;
                        attach.name = name;
                    }
                }
                // let name  = this.insertStr(attach.name, count, '('+moment(attach.create_dt).format('YYYYMMDDHHmmss')+')');
                // attach.name = name;
                debounceDownload(attach, list, index, num, this, isResume);
                common.messageToast({
                    message: "文件保存为" + attach.name,
                    type: 'success'
                });
            },
            cancelDownload: function (url, attach) {
                var currentDownload = this.downloaders[url];
                if (currentDownload) {
                    attach.isCanceled = true;
                    attach.isDownloading = false;
                    currentDownload.abort();
                }
            },
            openFolder: openFolder,
            //确认寻呼后的回调函数
            confirmPin: function (pin) {
                this.pinList.forEach(obj => {
                    if (obj.uid == pin.uid) {
                        obj.confirmed = true;
                    }
                })

            },
            isAssetTypeAnImage: function (name) {
                let index = name.lastIndexOf(".");
                return utils.isAssetTypeAnImage(name.substr(index + 1))
            },
            isShowDelayedIcon: function (pin) {
                if (!pin.delayed) {
                    return false;
                }
                var sendTime = pin.delayed_send_dt;
                var thisTime = new Date().getTime();
                return sendTime > thisTime;
            },
            // 确认寻呼
            pinConfirm: function (pin) {
                var that = this;
                if (pin.confirmed) {
                    return false;
                }
                pinApi.confirm(pin.uid, function () {
                    pin.confirmed = true;
                    common.messageToast({
                        type: 'success',
                        message: "确认成功"
                    });
                    // setupReceiverConfirm(that, im.loginUser.id);
                    // that.$emit('confirmPin', that.pinUid);
                    // that.inputFocus();
                });

            },
            //添加回复数量
            addCommentCount: function (pin) {
                this.pinList.forEach(obj => {
                    if (obj.uid == pin.uid) {
                        obj.comment_count += 1;
                    }
                })
            },
            isShowProgress: function (attach) {
                var isCanceled = attach.uploadStatus === utils.uploadStatus.CANCELLED;
                var isUploading = attach.uploadStatus === utils.uploadStatus.UPLOADING;
                return isCanceled || isUploading;
            },
            getProgress: function (attach) {
                return parseInt(attach.downloadProgress) + '%';
            },
            // 暂停
            pauseDownload: function (url, attach, index, num) {
                if (this.downloader) {
                    this.downloader.pause();
                }
                let pinObj = this.pinList[index].attachments[num]
                pinObj.isCanceled = true;
                pinObj.isDownloading = false;
                this.pinList[index].attachments.splice(num, 1, pinObj);

            },
            cancelDownload: function (url, attach) {
                var currentDownload = this.downloaders[url];
                if (currentDownload) {
                    currentDownload.abort()
                    currentDownload.onCancel();
                }
            },
            //显示包含搜索关键字
            showKeyword: function (pin) {
                let content = pin.content;
                let contain = false;
                if (this.ifHight) {
                    contain = (this.lightSearchObj && this.lightSearchObj.content != "") ? content.includes(this.lightSearchObj.content) : false
                } else {
                    contain = this.searchText != '' ? content.includes(this.searchText) : false
                }

                return this.ifSearch && contain

            },
            keywordLabel: function () {
                let kayword = this.ifHight ? this.lightSearchObj.content : this.searchText;
                return this.localeFormat(im.locale.pin.containKey, kayword);
            },
            //修改附件状态
            changeAttachStatus: function (data) {
                let _that = this
                Vue.nextTick(function () {
                    _that.pinList.filter(obj => obj.uid == data.uid)[0].attachments[data.index].downloadProgress = 100

                })

            },
            downloadOrOpen: function (attach, attachments, index, num) {
                let that = this;
                if (attach.isClick) {
                    return false
                }
                if (!attach.isDownloading && attach.downloadProgress === 0) {
                    attach.isClick = true;
                    that.download(attach, attachments, index, num)
                } else if (!attach.isDownloading && attach.downloadProgress === 100) {
                    this.openFolder(attach, true)
                } else {
                    return false
                }


            },
            enter(index, num) {
                this.showSetting = true;
                this.currentIndex = index;
                this.currentNum = num;
            },
            leave() {
                this.showSetting = false;
                this.currentNum = null;
                this.currentIndex = null;
            },
            saveAs(event, attach) {
                console.log(attach);
                let arr1 = attach.url.split('?') //arr1[0]=?前的路径
                let arr2 = arr1[0].split('/') //arr2[arr2.length-1] = 要取的字符串
                arr2[arr2.length - 1] = attach.name //替换文件名
                let str1 = arr2.join('/') //拼接字符串 str1= arr1[0] 也就是 ?前的路径
                arr1[0] = str1;
                let url = arr1.join('?') //拼接arr1就是完整url
                console.log(url);
                event.target.href = url
                console.log(event.target.href, attach.name, event);
            },
            _click() {
                return false;
            },
            remind: function (pin) {
                var dialog = RongIM.dialog;
                const dataObj = {
                    data: pin,
                    type: 'pin'
                }
                dialog.addChooseDate(dataObj)
                // dialog.addChooseDate(pin)
            },
            // 转日程
            gotoSchedule(pin) {
                var loginInfo = utils.cache.get('loginInfo');
                var link = 'http://219.142.112.25/skd-web-pc/index.html?useValidation=1#/third_login';
                let url = ''
                console.log("11", loginInfo, loginInfo.zkxToken);
                if (loginInfo && loginInfo.zkxToken) {
                    var token = decodeURIComponent(loginInfo.zkxToken) + ';path=/';
                    if (loginInfo.RCESESSIONID) {
                        link += "?pinId=" + pin.uid + '&userId=' + im.loginUser.id + "&sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                            "&uid=RY" + loginInfo.zkxEmpId
                    }
                    url = RongIM.config.loginServer + '/sign-bridge.html' + '?target=' + encodeURIComponent(link) +
                        '&token=' + encodeURIComponent(token);
                }
                console.log("url", url);
                RongIM.browserWindow.openPSArticle(url)
                // RongDesktop.browserWin.create({
                //     width:1000,
                //     minWidth: 800,
                //     path: url,
                // });
                // window.open(url);
            },
            // 转任务
            gotoTask(pin) {
                var loginInfo = utils.cache.get('loginInfo');
                var link = 'http://219.142.112.25/ttsms-web-pc/index.html?useValidation=1#/third_login';
                let url = ''
                if (loginInfo && loginInfo.zkxToken) {
                    var token = decodeURIComponent(loginInfo.zkxToken) + ';path=/';
                    if (loginInfo.RCESESSIONID) {
                        link += "?pinId=" + pin.uid + '&userId=' + im.loginUser.id + "&sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                            "&uid=RY" + loginInfo.zkxEmpId
                    }
                    url = RongIM.config.loginServer + '/sign-bridge.html' + '?target=' + encodeURIComponent(link) +
                        '&token=' + encodeURIComponent(token);
                }
                RongIM.browserWindow.openPSArticle(url)
                // RongDesktop.browserWin.create({
                //     width:1000,
                //     minWidth: 800,
                //     path: url,
                // });
                // window.open(url);
            },
            // 删除寻呼
            delPin(pin) {
                let that = this
                common.messagebox({
                    message: '确定删除该条寻呼吗？',
                    type: 'confirm',
                    callback: function () {
                        that.ifShowDetail = false
                        //先取消寻呼
                        pinApi.cancelPin(pin.uid, function (errorCode, res) {
                            // if(errorCode){
                            //     return;
                            // }
                            // if(res.code !='10000'){
                            //     return;
                            // }
                            //删除寻呼
                            pinApi.deletePin(pin.uid, function (error, res) {
                                if (error) {
                                    return;
                                }
                                common.messageToast({
                                    type: 'success',
                                    message: "删除成功"
                                });
                                //将寻呼在列表中删除
                                that.pinList.splice(that.pinList.findIndex(item => item.uid === pin.uid), 1)
                                that.pinCount -= 1
                            })
                        })
                    }
                });
            }

        };
    }

    function unique(arr) {
        const res = new Map();
        return arr.filter((arr) => !res.has(arr.uid) && res.set(arr.uid, 1));
    }
    // 模糊搜索
    function setupPinAllSearch(context, pinApi, timestamp, callback) {
        if (!context.hasMore || context.isLoading) {
            return;
        }
        context.isLoading = true;
        pinApi.allMobileSearch(context.searchText, timestamp, function (errorCode, result) {
            context.isLoading = false;
            if (errorCode) {
                return;
            }
            // context.pinList = result.data;
            // context.pinCount = result.total_count+context.pinList.length;
            if (timestamp == 0) {
                context.pinCount = result.total_count
            }
            context.pinList.length
            context.pinList = unique(context.pinList.concat(result.data));

            var count = context.pinList.length;
            if (count) {
                context.hasMore = result.total_count > result.count;
                context.minTimestamp = context.pinList[count - 1].create_dt;
            }
            context.pinList.forEach((obj, index) => {
                if (obj.attachment_count > 0) {
                    setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, result.data, index);
                }
            })
        });

    }
    // 高级搜索
    function allPcAccurateSearch(context, pinApi, timestamp, callback) {
        let param = {
            attachedName: context.searchObj.attachedName || '',
            contacts: context.searchObj.contacts || '',
            title: context.searchObj.title || '',
            content: context.searchObj.content || '',
            start: context.searchObj.start || 0,
            end: context.searchObj.end || '',
            timestamp: timestamp
        }
        context.isLoading = true;
        pinApi.allPcAccurateSearch(param, function (errorCode, result) {
            context.isLoading = false;
            if (errorCode) {
                return;
            }
            context.pinList = unique(context.pinList.concat(result.data));
            // context.pinCount = result.total_count
            if (timestamp == 0) {
                context.pinCount = result.total_count
            }
            var count = context.pinList.length;
            if (count) {
                context.hasMore = result.total_count > result.count;
                context.minTimestamp = context.pinList[count - 1].create_dt;
            }
            context.pinList.forEach((obj, index) => {
                if (obj.attachment_count > 0) {
                    setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, result.data, index);
                }
            })
        });

    }

    function setupPinAttachmentList(context, list, pinApi, uid, pinList, index) {
        var progress = {
            isDownloading: false,
            downloadProgress: 0,
            isCanceled: false
        };
        list = list.map(function (attach) {
            return $.extend(attach, progress);
        });
        list = list.map(function (atta) {
            var imageUrl = '//rongcloud-image.';
            var fileUrl = '//rongcloud-file.';
            if (atta.url.indexOf(imageUrl) === -1 && atta.url.indexOf(fileUrl) === -1) {
                atta.url = atta.url + '?attname=' + encodeURI(atta.name);
            }
            var downloadSize = loadDownloadStat(atta.uid);
            if (downloadSize) {
                atta.isCanceled = true;
                atta.downloadProgress = (downloadSize / atta.size) * 100;
            }
            //判断本地是否存在,
            let count = atta.name.lastIndexOf(".");
            let name = context.insertStr(atta.name, count, '_' + atta.uid);
            var localPath = pinApi.getPinLocalAttach(name);
            var fileExist = RongIM.file.checkExist(localPath);
            if (fileExist) {
                atta.rename = name;
            }
            return atta;
        });
        context.attachmentList = list;
        setupAttachDownload(context, pinList, index);
        setupAttachExists(context.attachmentList);
    }

    function setupAttachExists(attachmentList) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        if (attachmentList && attachmentList.length > 0) {
            attachmentList.forEach(function (attach) {
                setAttach(attach);
            });
        }
        function setAttach(attach) {
            var localPath = pinApi.getPinLocalAttach(attach.rename);
            var fileExist = RongIM.file.checkExist(localPath);
            if (fileExist) {
                attach.localPath = localPath;
                attach.downloadProgress = 100;
            }
        }
    }

    function loadDownloadStat(uId) {
        var fileState = RongIM.downloader.getProgress(uId);
        if (fileState.offset) {
            return fileState.offset;
        }
        return 0;
    }

    function initDownload(attach, pinList, index, num, _that, isResume) {
        /* var file = {url: fileUrl};
        var downloader = RongIM.download(file); */
        fileApi.getFileDownloadToken(function (error, token) {
            if (error) {
                common.toastError('download-error');
                return;
            }
            var url = attach.url;
            if (url.indexOf('?') !== -1) {
                url += '&token=' + token;
            } else {
                url += '?token=' + token;
            }
            var file = {
                url: url,
                name: attach.rename,
                size: attach.size,
                uId: attach.uid
            };
            var downloader = RongIM.downloader.load(file);

            downloader.onError = function () {

                // stateCode = ('download-' + params.state);
                // context.isDownloading = false;
                // context.isCanceled = true;
                // context.downloadProgress = 0;
                // common.handleError(stateCode);
            };

            // 下载准备完毕, 此时可知文件大小
            downloader.onReady = function (data) {
                _that.downloader = downloader;
                Vue.nextTick(function () {
                    // let pinObj = _that.pinList[index]
                    attach.isDownloading = true
                    attach.isCanceled = false
                    attach.isClick = false;
                    // _that.pinList.splice(index, 1, pinObj);
                })
            };

            // 下载中,返回下载进度
            downloader.onProgress = function (data) {
                Vue.nextTick(function () {
                    let pinObj = _that.pinList[index].attachments[num]
                    pinObj.isDownloading = true
                    pinObj.isCanceled = false
                    // pinObj.uploadStatus = 1
                    pinObj.loaded = data.loaded
                    attach.downloadProgress = (data.loaded / data.total) * 100 > 100 ? 100 : (data.loaded / data.total) * 100;
                    _that.pinList[index].attachments.splice(num, 1, pinObj);
                })
            };

            // 下载完成
            downloader.onComplete = function (data) {
                // Vue.nextTick(function () {
                //     let pinObj = _that.pinList[index].attachments[num]
                //     pinObj.isDownloading = false
                //     pinObj.isClick = false;
                //     _that.pinList[index].attachments.splice(num, 1, pinObj);
                // })
                if (!data.path) {
                    return;
                }
                attach.localPath = data.path;
                // attach.name = attach.rename;
                attach.isDownloading = false
                attach.isClick = false;
                _that.pinList[index].attachments.splice(num, 1, attach);
                saveLocalAttach(attach, data.path);

            };

            // 下载取消
            downloader.onCancel = function () {
                // context.isDownloading = false;
                // context.isCanceled = false;
                // context.downloadProgress = 0;
                Vue.nextTick(function () {
                    let pinObj = _that.pinList[index].attachments[num]
                    pinObj.isDownloading = false
                    pinObj.isCanceled = false;
                    pinObj.downloadProgress = 0;
                    pinObj.isClick = false;
                    _that.pinList[index].attachments.splice(num, 1, pinObj);
                })
                attach.downloader = {};
            };
            // context.downloadStatus = 'DOWNLOADING';
            //继续
            if (isResume) {
                downloader.continue();
                return;
            }
            downloader.saveAs();

            // attach.downloaders[attach.url] = downloader;
        });
    }

    function saveLocalAttach(attach, localPath) {

        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        pinApi.addPinLocalAttach(attach.rename, localPath);
    }

    function setupAttachDownload(context, pinList, index) {
        context.attachmentList.forEach(function (attach, num) {
            attach.downloaders = context.downloaders;
        });
    }

    function openFolder(attach, isClickName) {
        var file = RongIM.file;
        var localPath = attach.localPath;
        var fileExist = file.checkExist(localPath);
        if (attach.isDownloading && fileExist) {
            return;
        }
        if (localPath && fileExist) {
            // file.openDir(localPath);
            if (isClickName) {
                file.open(localPath);
            } else {
                file.openDir(localPath);
            }


        } else {
            common.toastError('file-404');
            attach.downloadProgress = 0;
            removeLocalAttach(attach);
        }
    }

    function removeLocalAttach(attach) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        pinApi.removeLocalAttach(attach.rename);
    }

    function getContextMenu() {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        var options = {
            template: 'modules/pin/templates/deletepin-contextmenu.html',
            methods: {
                deletePin: function () {
                    var that = this;
                    var pin = this.context.pin;
                    pinApi.deletePin(pin.uid, function () {
                        that.$emit('close');
                        im.$emit('deletePin', pin);
                        pinApi.notifyUnReadCount();
                    });
                }
            }
        };
        return components.getContextMenu(options);
    }

    function watchDeletePin(context) {
        var im = RongIM.instance;
        im.$on('deletePin', function (pin) {
            context.pinList = context.pinList.filter(function (pinDetail) {
                return pinDetail.uid !== pin.uid;
            });
        });
    }

    function watchConnectStatus(context, pinApi) {
        var im = RongIM.instance;
        im.$watch('status', function (status) {
            if (status === utils.status.CONNECTED) {
                setupPinAll(context, pinApi, context.minTimestamp);
            }
        });
    }

    var throttleMap = {};

    function setupPinDetailThrottle(context, pinApi, pin, callback) {

        setupPinDetail(context, pinApi, pin, callback);
    }

    function setupPinDetail(context, pinApi, pin, callback) {

        pinApi.getPinDetail(pin.uid, function (errorCode, detail) {
            if (errorCode) {
                return;
            }
            // delete detail.attachments
            $.extend(pin, detail);
            if (callback) callback(detail);
        });
    }

    function pinCreateWatch(context, pinApi) {
        context.pinCreateWatch = function (message) {
            console.log("pinCreatedWatch ==> ", message);
            //如果处在搜索状态
            if (context.ifSearch) {
                return;
            }
            var isCreateMessage = message.messageType === pinApi.MessageType.PinNotifyMessage;
            var pinIdList = context.pinList.map(function (pin) {
                return pin.uid;
            });
            console.log("pinIdList", pinIdList);
            var isNewPin = isCreateMessage && pinIdList.indexOf(message.content.pinUid) === -1;
            if (isNewPin) {
                message.content.uid = message.content.pinUid;
                setupPinDetail(context, pinApi, message.content, function (pin) {
                    console.log('setupPinDetail ==> ', pin);
                    var list = context.pinList.concat([]);
                    setupAttachExists(pin.attachments)
                    list.unshift(pin);
                    context.pinList = deleteRepeatPin(list);
                    context.pinList.forEach((obj, index) => {
                        if (obj.attachment_count > 0) {
                            setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, context.pinList, index);
                        }
                    })
                });
            }
        };
        pinApi.watch(context.pinCreateWatch);
    }

    function pinChangeWatch(context, pinApi) {
        var im = RongIM.instance;
        context.pinChangeWatch = function (message) {
            var isCommentMessage = message.messageType === pinApi.MessageType.PinCommentMessage;
            var isUnReadMessage = message.messageType === pinApi.MessageType.PinCommentReadMessage;
            //确认寻呼通知
            var isConfirmMessage = message.messageType === pinApi.MessageType.PinConfirmMessage;
            //是被撤回的消息通知吗
            var isPinRevokeMessage = message.messageType === pinApi.MessageType.PinRevokeMessage;
            //添加新的接收人
            var isMessageType = message.messageType === pinApi.MessageType.PinNewReciverMessage;
            if (isCommentMessage || isUnReadMessage || isConfirmMessage || isMessageType) {
                context.pinList.forEach(function (pin) {
                    if (pin.uid === message.content.pinUid) setupPinDetailThrottle(context, pinApi, pin);
                });
            }
            //撤回寻呼
            if (isPinRevokeMessage) {
                context.pinList.forEach(function (pin, index) {
                    if (pin.uid === message.content.pinUid) {
                        pin.title = '已撤回';
                        let pinObj = pin;
                        context.pinList.splice(index, 1, pinObj);
                    }
                });

                //判断是否查看详情
                if (context.ifShowDetail) {
                    common.messagebox({
                        message: im.locale.pin.revokePin,
                        callback: function () {
                            context.selectedPin = {}
                            context.ifShowDetail = false
                            context.close();
                        },
                        closeCallback: function () {
                            context.close();
                        },
                        hashchangeClose: false
                    });


                }

            }
        };
        pinApi.watch(context.pinChangeWatch);
    }

    function pinDeleteWatch(context, pinApi) {
        context.pinDeleteWatch = function (message) {
            var isDeleteMessage = message.messageType === pinApi.MessageType.PinDeletedMessage;
            if (isDeleteMessage) {
                context.pinList = context.pinList.filter(function (pin) {
                    return pin.uid !== message.content.pinUid;
                });
            }
        };
        pinApi.watch(context.pinDeleteWatch);
    }

    function isScrollToBottom() {
        var $el = $('.rong-main-content');
        if (!$el) return false;
        var bottom = $el.css('padding-bottom');
        if (!bottom) return false;
        bottom = parseFloat(bottom.split('px')[0]);
        //滚动高度
        var scrollTop = $el[0].scrollTop;
        //div高度
        var height = $el.height();
        //内容
        var scrollHeight = $el[0].scrollHeight;
        return scrollTop + height >= scrollHeight - bottom - 100;
    }

    function setupPinAll(context, pinApi, timestamp, callback) {
        if (!context.hasMore || context.isLoading) {
            return;
        }
        context.isLoading = true;
        pinApi.allPins(timestamp, function (errorCode, result) {
            context.isLoading = false;
            if (errorCode) {
                return;
            }
            context.pinList = unique(context.pinList.concat(result.data));
            var count = context.pinList.length;
            if (count) {
                context.hasMore = result.total_count > result.count;

                // context.minTimestamp = context.pinList[count - 1].create_dt;

                context.minTimestamp = context.pinList[count - 1].send_dt || context.pinList[count - 1].create_dt;
                // if (callback) callback();
            }

            context.pinList.forEach((obj, index) => {
                if (obj.attachment_count > 0) {
                    setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, result.data, index);
                }
            })
            // context.sentList = context.pinList.filter(obj =>obj.type == 0)
        });
    }


    function setPinConfirm(pin, pinApi) {
        var $def = $.Deferred();
        pinApi.confirm(pin.uid, function () {
            pin.confirmed = true;
            $def.resolve();
        }, function (err) {
            $def.reject(err);
        });

        return $def;
    }

    function deleteRepeatPin(pinList) {
        var newList = [];
        for (var i = 0; i < pinList.length; i += 1) {
            var pin = pinList[i];
            var newPinUid = newList.map(function (newPin) {
                return newPin.uid;
            });
            if (newPinUid.indexOf(pin.uid) === -1) {
                newList.push(pin);
            }
        }
        return newList;
    }

    $.extend(true, components, {
        pin: {
            getAllPins: getAllPins
        }
    });
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));