(function (RongIM, dependencies, components) {
    'use strict';
    var Http = RongIM.dataModel._Http;
    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var pinApi = dataModel.Pin;
    var orgazApi = RongIM.dataModel.Organization;
    var immediately = 'Immediately';
    var days = []

    RongIM.dialog.addChooseDate = function (data, callback) {
        var im = RongIM.instance;
        var enabledSms = im.serverConfig.sms.verification_state;
        var maxReceiverCount = im.serverConfig.pin.max_receiver_count;
        var options = {
            name: 'choose-date',
            template: 'modules/pin/templates/choose-date.html',
            data: function () {
                return {
                    days: [],
                    show: true,
                    dateList: [],
                    weekArr: ['日', '一', '二', '三', '四', '五', '六'],
                    totalRow: 1,
                    currentDay: '',
                    currentTime: '',
                    activeDay: 0,
                    calendarList: [],
                    currentMonth: 0,
                    currentYear: 0,
                    showTimePanal: false,
                    isScroll: false,
                    scrollTop: 0,
                    scrollHTop: 0,
                    scrollMTop: 0,
                    hourValue: 0,
                    minuteValue: 0,
                    originalHour: 0,
                    originalMinute: 0,
                    scrollHEnd: 0,
                    scrollMEnd: 0,
                    intervalId: {
                        hour: null,
                        time: null
                    },
                    intervalHour: null,
                    intervalTime: null,
                    objData: data,
                    hourList: [],
                    minuteList: [],
                    toDay: new Date(),
                    initMinute: [],
                    initHour: [],
                    originalMinuteList: [],
                    originalHourList: []
                };
            },
            components: {
                avatar: components.getAvatar,
                org: components.group.getOrg,
                friend: components.group.getFriend,
                star: components.group.getStar,
                group: components.group.getGroup,
                addAttachment: components.addAttachment,
                customSelect: components.customSelect,
                pinDetail: components.getPinDetail

            },
            inject: ['reload'], //刷新页面不闪烁
            computed: {

            },
            created: function () {
                this.getDate()
                for (let i = 0; i < 24; i++) {
                    this.initHour.push(i)
                }
                for (let i = 0; i < 60; i++) {
                    this.initMinute.push(i)
                }
                // this.minuteValue
            },
            methods: getMethods(im, callback),
            watch: {
            }
        };
        common.mountDialog(options);
    };

    function getMethods(im, callback) {
        return {
            getDate: function () {
                const currentDate = new Date()
                this.hourList = []
                this.minuteList = []
                // if (currentDate.getMinutes() >= 30) {
                //     this.minuteValue = currentDate.getMinutes() - 30
                //     this.hourValue = currentDate.getHours() + 1
                // } else {
                //     this.minuteValue = currentDate.getMinutes() + 30
                //     this.hourValue = currentDate.getHours()
                // }
                this.minuteValue = currentDate.getMinutes()
                this.hourValue = currentDate.getHours()
                this.originalHour = this.hourValue
                this.originalMinute = this.minuteValue
                for (let i = this.hourValue; i < 24; i++) {
                    this.hourList.push(i)
                    this.originalHourList.push(i)
                }
                for (let i = this.minuteValue; i < 60; i++) {
                    this.minuteList.push(i)
                    this.originalMinuteList.push(i)
                }

                // 获取当前年份
                const year = currentDate.getFullYear()
                // 获取当前月份
                const month = currentDate.getMonth() + 1
                // 获取当前日
                const day = currentDate.getDate()
                this.activeDay = day
                this.currentDay = year + '-' + (month > 9 ? month : '0' + month) + '-' + (day > 9 ? day : '0' + day)
                this.currentTime = (this.hourValue > 9 ? this.hourValue : '0' + this.hourValue) + ':' + (this.minuteValue > 9 ? this.minuteValue : '0' + this.minuteValue)
                // 拿到当前月份总共几天
                this.days = new Date(year, month, 0).getDate()
                // 获取当前月份第一天是周几
                this.currentMonth = month
                this.currentYear = year
                const week = new Date(year + '-' + month + '-01').getDay()
                this.calendarList[0] = []
                for (let i = 0; i < 7; i++) {
                    this.calendarList[0][i] = {}
                }

                for (let i = 1; i <= this.days; i++) {
                    const weekIndex = (week + i - 1) % 7
                    // if (weekIndex === 0 && (week % 7) !== 0) this.totalRow++
                    if (weekIndex === 0 && i !== 1) this.totalRow++
                    const dateObject = {
                        day: i,
                        weekIndex: weekIndex,
                        week: this.weekArr[weekIndex],
                        rowIndex: this.totalRow,
                        isToday: day === i,
                        month: month,
                        year: year,
                        todayBeforOrAfter: day <= i ? 'after' : 'befor'
                    }
                    if (!this.calendarList[this.totalRow - 1]) this.calendarList[this.totalRow - 1] = [{}, {}, {}, {}, {}, {}, {}]
                    this.calendarList[this.totalRow - 1][weekIndex] = dateObject
                    this.dateList.push(dateObject)
                    // console.log(year + '-' + month + '-01', this.dateList)
                }
                console.log(year + '-' + month + '-01', this.calendarList)
            },
            clickDayItem: function (item, isClick) {
                const currentDate = new Date()
                if (item.day && isClick) {
                    this.activeDay = item.day
                    this.currentDay = item.year + '-' + (item.month > 9 ? item.month : '0' + item.month) + '-' + (item.day > 9 ? item.day : '0' + item.day)
                    this.minuteList = []
                    this.hourList = []
                    this.minuteList = Object.assign([], this.initMinute)
                    // for (let i = 0; i < 60; i++) {
                    //     this.minuteList.push(i)
                    // }
                    if (item.isToday) {
                        // if (currentDate.getMinutes() >= 30) {
                        //     this.originalMinute = currentDate.getMinutes() - 30
                        //     this.originalHour = currentDate.getHours() + 1
                        // } else {
                        //     this.originalMinute = currentDate.getMinutes() + 30
                        //     this.originalHour = currentDate.getHours()
                        // }
                        this.originalMinute = currentDate.getMinutes()
                        this.originalHour = currentDate.getHours()
                        for (let i = this.originalHour; i < 24; i++) {
                            this.hourList.push(i)
                        }
                        if (this.hourValue < this.originalHour) {
                            this.minuteList = []
                            this.hourValue = this.originalHour
                            for (let i = this.originalMinute; i < 60; i++) {
                                this.minuteList.push(i)
                            }
                            console.log('this.minuteList.push(i)1', this.minuteList)
                        }
                        if (this.hourValue === this.originalHour && this.minuteValue <= this.originalMinute) {
                            this.minuteList = []
                            this.minuteValue = this.originalMinute
                            for (let i = this.originalMinute; i < 60; i++) {
                                this.minuteList.push(i)
                            }
                        } else {
                            this.minuteList = []
                            for (let i = this.originalMinute; i < 60; i++) {
                                this.minuteList.push(i)
                            }
                        }
                        this.currentTime = (this.hourValue > 9 ? this.hourValue : '0' + this.hourValue) + ':' + (this.minuteValue > 9 ? this.minuteValue : '0' + this.minuteValue)
                    } else {
                        this.hourList = Object.assign([], this.initHour)
                    }
                }
            },
            switchMonth: function (currentYear, currentMonth) {
                if (currentMonth > 12) {
                    this.currentYear++
                    currentYear++
                    this.currentMonth = 1
                    currentMonth = 1
                } else if (currentMonth < 1) {
                    this.currentYear--
                    currentYear--
                    this.currentMonth = 12
                    currentMonth = 12
                }
                this.totalRow = 1
                const currentDate = new Date()
                this.calendarList = []
                // 获取当前年份
                // const year = this.currentYear
                const year = currentYear
                // 获取当前月份
                // const month = this.currentMonth
                const month = currentMonth
                // 获取日
                const day = (this.activeDay < currentDate.getDate() && month === currentDate.getMonth() + 1) ? currentDate.getDate() : this.activeDay
                this.activeDay = day
                this.currentDay = year + '-' + (month > 9 ? month : '0' + month) + '-' + (day > 9 ? day : '0' + day)
                // 拿到当前月份总共几天
                this.days = new Date(year, month, 0).getDate()
                // 获取当前月份第一天是周几
                const week = new Date(year + '-' + month + '-01').getDay()
                this.calendarList[0] = []
                for (let i = 0; i < 7; i++) {
                    this.calendarList[0][i] = {}
                }
                for (let i = 1; i <= this.days; i++) {
                    const weekIndex = (week + i - 1) % 7
                    if (weekIndex === 0 && i !== 1) this.totalRow++
                    const ISTAY = year === currentDate.getFullYear() && month === (currentDate.getMonth() + 1) && i === currentDate.getDate()
                    const dateObject = {
                        day: i,
                        weekIndex: weekIndex,
                        week: this.weekArr[weekIndex],
                        rowIndex: this.totalRow,
                        isToday: ISTAY,
                        month: month,
                        year: year,
                        // todayBeforOrAfter: year === currentDate.getFullYear() ? (month === (currentDate.getMonth() + 1) ? (currentDate.getDate() <= i ? 'after' : 'befor') : (month > (currentDate.getMonth() + 1) ? 'after' : 'befor')) : 'after'
                        todayBeforOrAfter: ISTAY ? 'today' : (currentDate.getTime() - (1000 * 60 * 60 * 24) < new Date(year + '-' + month + '-' + i) - (1000 * 60 * 60 * 8) ? 'after' : 'befor')
                    }
                    if (!this.calendarList[this.totalRow - 1]) this.calendarList[this.totalRow - 1] = [{}, {}, {}, {}, {}, {}, {}]
                    this.calendarList[this.totalRow - 1][weekIndex] = dateObject
                    this.dateList.push(dateObject)
                }
                console.log(year + '-' + month + '-01', this.calendarList)
            },
            chooseTime: function () {
                this.showTimePanal = true
                setTimeout(() => {
                    this.$refs.timeHour.scrollTop = this.hourList.indexOf(this.hourValue) * 21
                    // this.$refs.timeMinute.scrollTop = this.minuteValue * 21
                    this.$refs.timeMinute.scrollTop = this.minuteList.indexOf(this.minuteValue) * 21
                }, 100)
            },
            hourScroll: function (event) {
                this.scrollHTop = event.target.scrollTop
                this.hourValue = this.hourList[Math.round(this.scrollHTop / 21)]
                if (this.hourList[0] === this.originalHour) {// 还有增加判断当天的校验
                    if (this.hourValue > this.hourList[0]) {
                        this.minuteList = Object.assign([], this.initMinute)
                        this.$nextTick(() => {
                            this.$refs.timeMinute.scrollTop = this.minuteValue * 21
                            this.scrollMTop = this.$refs.timeMinute.scrollTop
                        })

                    } else {
                        this.minuteList = []
                        this.minuteValue = this.minuteValue < this.originalMinute ? this.originalMinute : this.minuteValue
                        this.minuteList = Object.assign([], this.originalMinuteList)
                        this.$refs.timeMinute.scrollTop = this.minuteList.indexOf(this.minuteValue) * 21
                    }
                }
                this.currentTime = (this.hourValue > 9 ? this.hourValue : '0' + this.hourValue) + ':' + (this.minuteValue > 9 ? this.minuteValue : '0' + this.minuteValue)
                if (!this.intervalHour) {
                    this.createHourTimer(event)
                }
            },
            createHourTimer: function (event, key) {
                this.intervalHour = setInterval(() => {
                    if (this.scrollHEnd !== this.scrollHTop) {
                        this.scrollHEnd = this.scrollHTop
                    } else {
                        clearInterval(this.intervalHour)
                        this.intervalHour = null
                        event.target.scrollTop = Math.round(this.scrollHTop / 21) * 21
                    }
                }, 100); // 1000毫秒，即1秒
            },
            clickHourItem: function (hour) {
                console.log(this.$refs)
                this.$refs.timeHour.scrollTop = this.hourList.indexOf(hour) * 21
                this.hourValue = hour
                this.currentTime = (this.hourValue > 9 ? this.hourValue : '0' + this.hourValue) + ':' + (this.minuteValue > 9 ? this.minuteValue : '0' + this.minuteValue)
            },
            clickMinuteItem: function (minute) {
                console.log(this.$refs)
                this.$refs.timeMinute.scrollTop = this.minuteList.indexOf(minute) * 21
                this.minuteValue = minute
                this.currentTime = (this.hourValue > 9 ? this.hourValue : '0' + this.hourValue) + ':' + (this.minuteValue > 9 ? this.minuteValue : '0' + this.minuteValue)
            },
            timeScroll: function (event, isScroll) {
                // if (event.target.className === 'time-hour') {
                // key = 'hour'
                // this.scrollHTop = event.target.scrollTop
                // this.hourValue = this.hourList[Math.round(this.scrollHTop / 21)]
                // if (this.hourList[0] === this.originalHour) {// 还有增加判断当天的校验
                //     if (this.hourValue > this.hourList[0]) {
                //         this.minuteList = Object.assign([], this.initMinute)
                //         this.$refs.timeMinute.scrollTop = this.minuteValue * 21
                //         this.scrollMTop = this.$refs.timeMinute.scrollTop
                //     } else {
                //         this.minuteList = []
                //         this.minuteValue = this.minuteValue < this.originalMinute ? this.originalMinute : this.minuteValue
                //         this.minuteList = Object.assign([], this.originalMinuteList)
                //         this.$refs.timeMinute.scrollTop = this.minuteList.indexOf(this.minuteValue) * 21
                //     }
                // }
                // if (!this.intervalHour) {
                //     this.createTimer(event, key)
                // }
                // } else {
                this.scrollMTop = event.target.scrollTop
                this.minuteValue = this.minuteList[Math.round(this.scrollMTop / 21)]

                // }
                this.currentTime = (this.hourValue > 9 ? this.hourValue : '0' + this.hourValue) + ':' + (this.minuteValue > 9 ? this.minuteValue : '0' + this.minuteValue)
                if (!this.intervalTime) {
                    this.createTimer(event)
                }
                // if (!this.intervalHour) {
                //     this.createTimer(event, key)
                // }
            },
            clickOther: function (e) {
                const classNames = e.target.className.split(' ')
                const template = 'time-input,time-panal,time-hour,time-minute,hourItem,minuteItem,chooseTime-currentTime,activeTime'
                if (classNames.filter(item => !template.includes(item)).length > 0 || e.target.className === '') {
                    this.showTimePanal = false
                }
            },
            createTimer: function (event) {
                // if (key === 'hour') {
                //     console.log('hourTimer')
                //     this.intervalHour = setInterval(() => {
                //         // if (event.target.className === 'time-hour') {
                //         if (this.scrollEnd !== this.scrollHTop) {
                //             this.scrollEnd = this.scrollHTop
                //         } else {
                //             clearInterval(this.intervalHour)
                //             this.intervalHour = null
                //             event.target.scrollTop = Math.round(this.scrollHTop / 21) * 21
                //         }
                //         // }

                //     }, 100); // 1000毫秒，即1秒
                // } else {
                console.log('timeTimer')
                this.intervalTime = setInterval(() => {
                    // if (event.target.className === 'time-hour') {
                    //     if (this.scrollEnd !== this.scrollHTop) {
                    //         this.scrollEnd = this.scrollHTop
                    //     } else {
                    //         clearInterval(this.intervalTime)
                    //         this.intervalTime = null
                    //         event.target.scrollTop = Math.round(this.scrollHTop / 21) * 21
                    //     }
                    // } else {
                    if (this.scrollMEnd !== this.scrollMTop) {
                        this.scrollMEnd = this.scrollMTop
                    } else {
                        clearInterval(this.intervalTime)
                        this.intervalTime = null
                        event.target.scrollTop = Math.round(this.scrollMTop / 21) * 21
                    }
                    // }

                }, 100); // 1000毫秒，即1秒
                // }
                // this.intervalId[key] = setInterval(() => {
                //     if (event.target.className === 'time-hour') {
                //         if (this.scrollEnd !== this.scrollHTop) {
                //             this.scrollEnd = this.scrollHTop
                //         } else {
                //             clearInterval(this.intervalId[key])
                //             this.intervalId[key] = null
                //             event.target.scrollTop = Math.round(this.scrollHTop / 21) * 21
                //         }
                //     } else {
                //         if (this.scrollEnd !== this.scrollMTop) {
                //             this.scrollEnd = this.scrollMTop
                //         } else {
                //             clearInterval(this.intervalId[key])
                //             this.intervalId[key] = null
                //             event.target.scrollTop = Math.round(this.scrollMTop / 21) * 21
                //         }
                //     }

                // }, 100); // 1000毫秒，即1秒
            },
            confirmTX: function () {
                const dateTime = new Date(this.currentDay + ' ' + this.currentTime + ':00').getTime()
                const nowTime = new Date().getTime()
                const _this = this
                if (dateTime <= nowTime) {
                    common.messagebox({
                        message: "提醒时间必须大于当前时间！"
                    });
                    return
                }
                if (this.objData.type === 'message') {
                    const dataParams = {
                        delayed_send_time: dateTime,
                        userId: this.objData.data.user.id,
                        content: this.objData.data.content.content
                    }
                    debugger
                    Http.post('/pins/messageRemind', dataParams, function (errorCode, result) {
                        _this.show = false
                        common.messagebox({
                            message: "设置提醒成功！科协一家会将提醒信息通过短信方式通知给您。"
                        });
                    }).fail(callback)
                } else if (this.objData.type === 'pin') {
                    console.log(this.objData)
                    const dataParams = {
                        delayed_send_time: dateTime,
                        pin_uid: this.objData.data.uid
                    }
                    const urlHttp = this.objData.data.type === 1 ? '/pins/pinInboxRemind' : '/pins/pinOutboxRemind'
                    Http.post(urlHttp, dataParams, function (errorCode, result) {
                        _this.show = false
                        common.messagebox({
                            message: "设置提醒成功！科协一家会将提醒信息通过短信方式通知给您。"
                        });
                    }).fail(callback)
                }

            },
            cancelTX: function () {
                this.show = false
            }
        };
    }

    function resetInputFileValue(inputId) {
        var $inputFile = $('#' + inputId);
        $inputFile.val('');
    }

    function checkAttachInBound(context, fileList) {
        // PIN 携带的附件最大数
        var serverConfig = RongIM.serverConfig;
        var maxAttachCount = serverConfig.pin.max_attachment_count;
        // 附件个数设置
        var attachCount = context.attachments.length + fileList.length;
        var isBeyond = attachCount > maxAttachCount;

        return !isBeyond;
    }
    // 获取转发记录
    function getForwardPin(context, pinApi, uid) {
        pinApi.getPinDetail(uid, function (errorCode, result) {
            if (errorCode) {
                return;
            }

            context.forwardPins = result.forwardPins
        })
    }

    function createPin(context, im, sendParams) {
        context.isSending = true;
        if (context.isSend) {
            context.isSend = false
            pinApi.create(sendParams, function (errorCode, result) {
                context.isSend = true
                context.isSending = false;
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                sendMessageWhenInSendpinPage(im, result);
                afterCreatePin(context, sendParams, result, im);
            });
        }

    }

    function afterCreatePin(context, sendParams, result, im) {
        common.messagebox({
            message: context.locale.components.newPin.success,
            callback: function () {
                let timestamp = (new Date()).getTime();

                result.attachments = sendParams.attachments.map(obj => {
                    return {
                        ...obj,
                        isDownloading: false,
                        downloadProgress: 100
                    }
                })
                // 如果是定时发送  定时发送只在发送成功后发通知
                if (result.delayed) {
                    im.$emit('createPin', result)
                }

                context.close();
            },
            closeCallback: function () {
                context.close();
            },
            hashchangeClose: false
        });

    }

    function sendMessageWhenInSendpinPage(im, result) {
        if (im.$route.name !== 'pin-sent') {
            return;
        }
        // content = $.extend(content, { creatorUid: content.creator_uid, timestamp: content.create_dt });
        var message = {
            messageType: pinApi.MessageType.PinNotifyMessage,
            content: {
                pinUid: result.uid,
                creatorUid: result.creatorUid,
                timestamp: result.timestamp,
                content: result.content
            }
        };
        pinApi.observerList.notify(message);
    }

    function calcDate(dateType, addNumber) {
        var im = RongIM.instance;
        var date = new Date(this.selectedTime);
        switch (dateType) {
            case 0:
                var year = date.getFullYear();
                date.setFullYear(year + addNumber);
                break;
            case 1:
                var month = date.getMonth();
                date.setMonth(month + addNumber);
                break;
            case 2:
                var day = date.getDate();
                date.setDate(day + addNumber);
                break;
            case 3:
                var hour = date.getHours();
                date.setHours(hour + addNumber);
                break;
            case 4:
                var minute = date.getMinutes();
                date.setMinutes(minute + addNumber);
                break;
            default:
                break;
        }
        var thisTime = new Date().getTime();
        if (thisTime > date.getTime()) {
            this.toast({
                type: 'error',
                message: im.locale.components.newPin.pastTime
            });
            return;
        }
        date.setSeconds(0);
        date.setMilliseconds(0);
        this.selectedTime = date.getTime();
    }

    function formatDate(type, date) {
        var year = date.getFullYear();
        var month = date.getMonth() + 1;
        var day = date.getDate();
        var hour = date.getHours();
        var minute = date.getMinutes();
        switch (type) {
            case 0:
                return year;
            case 1:
                return month;
            case 2:
                return day;
            case 3:
                return hour;
            case 4:
                return minute;
            default:
                var addZeroWhenSingle = function (number) {
                    return (number + '').length > 1 ? number : ('0' + number);
                };
                var hourMark = addZeroWhenSingle(hour);
                var minuteMark = addZeroWhenSingle(minute);
                return year + '/' + month + '/' + day + ' ' + hourMark + ':' + minuteMark;
        }
    }

    function added(context, members, im) {
        var selectedIdList = context.selected.map(function (item) {
            return item.id;
        });
        var addedList = members.filter(function (item) {
            var hasSelected = selectedIdList.indexOf(item.id) < 0;
            var notSelf = item.id !== im.loginUser.id;
            return hasSelected && notSelf;
        });
        var totalList = context.selected.concat(addedList);
        context.selected = totalList;
        totalList = totalList.filter(function (item) {
            return !context.executiveLimit(item);
        });

        // PIN 最大人数由服务端下发
        var maxReceiverCount = context.maxReceiverCount;
        var mostReceiveFormat = im.locale.components.newPin.mostReceive;
        var hintMessage = context.localeFormat(mostReceiveFormat, maxReceiverCount);
        if (totalList.length > maxReceiverCount) {
            context.toast({
                type: 'error',
                message: hintMessage
            });
            removed(context, addedList);
        }
    }

    function removed(context, members) {
        var idList = members.map(function (item) {
            return item.id;
        });
        var reservedIdList = context.defaultSelected.map(function (item) {
            return item.id;
        });
        context.selected = context.selected.filter(function (item) {
            var reserved = reservedIdList.indexOf(item.id) >= 0;
            return reserved || idList.indexOf(item.id) < 0;
        });
    }

    function upload(file, context) {
        var models = RongIM.instance.dataModel;
        var pin = models.Pin;
        var getFileType = utils.getFileType;
        var fileType = getFileType(file.name);
        var attach = {
            data: file,
            progress: 0,
            url: null,
            uploadId: Date.now(),
            uploadStatus: utils.uploadStatus.READY,
            rawSize: file.size
        };
        context.attachments.push(attach);
        pin.uploadAttach(fileType, file, attach, function (err) {
            if (err) {
                utils.console.warn('上传失败');
                return;
            }
            saveLocalAttach(attach.data, attach.data.path);
        });
    }

    function saveLocalAttach(attach, localPath) {
        var im = RongIM.instance;
        im.dataModel.Pin.addPinLocalAttach(attach.name, localPath);
    }
}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));