(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var common = RongIM.common;
    function getNav(resolve, reject) {
        var im = RongIM.instance;
        var dialog = RongIM.dialog;
        var dataModel = im.dataModel;
        var system = RongIM.system;
        var options = {
            name: 'pin-nav',
            template: 'modules/pin/templates/nav.html',
            provide() {
                return {
                    reload: this.reload
                }
            },
            data: function () {
                return {
                    isShowMenu: false,
                    selectedTimespan: '',
                    receivedUnReadCount: {
                        unConfirm: 0,
                        unComment: 0
                    },
                    sentUnReadCount: 0,
                    bound: {
                        width: {
                            min: 0,
                            max: 0
                        }
                    },
                    ifNeeddHigh: this.$route.name == 'pin-replyOrConfirm' || this.$route.name == 'pin-newReply',
                    ifHigtSearch: false, //是否高级搜索
                    searchObj: {
                        start: '',
                        end: '',
                        contacts: '',
                        title: '',
                        attachedName: '',
                        content: ''
                    },
                    // startDate: moment(), //开始时间
                    // endDate:  moment(), //结束时间
                    startDate: null, //开始时间
                    endDate: null, //结束时间
                    isRouterAlive: true
                };
            },
            computed: {
                os: function () {
                    return system.platform;
                },
                _self: function () {
                    return this;
                },
                inSentPin: function () {
                    return im.$route.path.indexOf('sent') > -1;
                },
                isReplyOrConfirm: function () {
                    return im.$route.path.indexOf('replyOrConfirm') > -1;
                },
                unreadReceivedCount: function () {
                    return this.unconfirmCount + this.uncommentCount;
                },
                //待确认数量
                unconfirmCount: function () {

                    return this.receivedUnReadCount.unConfirm
                },
                uncommentCount: function () {
                    return this.receivedUnReadCount.unComment;
                },
                width: function () {
                    var node = im.resizeNode.rongList;
                    return node.width;
                },
                searchBarStyle: function () {
                    if (this.selectedPin) {
                        return {
                            'max-width': 'calc(100% - 420px)',
                            'min-width': '120px',
                            width: '40%',
                            left: '20%'
                        };
                    }
                    return {
                        width: '40%',
                    };
                },
                //搜索按钮置灰
                btnDisabled: function () {
                    return im.$route.path.indexOf('replyOrConfirm') > -1 || im.$route.path.indexOf('newReply') > -1;
                },
                //搜索框只读
                inputReadOnly: function () {
                    return this.ifHigtSearch || im.$route.path.indexOf('replyOrConfirm') > -1 || im.$route.path.indexOf('newReply') > -1
                }
            },
            components: {
                // search: components.getSearch
                customSelect: components.customSelect,
                pinSearch: components.getPinSearch
            },
            mounted: function () {

                if (!this.ifNeeddHigh) {
                    this.ifHigtSearch = Boolean(localStorage.getItem('ifHigtSearch'))
                } else {
                    this.ifHigtSearch = false;
                }
                let that = this;
                mounted(this, dataModel.Pin, im);
                initDate(that);
                if (localStorage.getItem("searchObj")) {
                    let param = JSON.parse(localStorage.getItem("searchObj"))
                    if (!checkEmpty(param)) {
                        this.searchObj = JSON.parse(localStorage.getItem("searchObj"));
                        this.startDate = this.searchObj.start ? moment(this.searchObj.start).format("YYYY-MM-DD HH:mm:ss") : ""
                        this.endDate = this.searchObj.end ? moment(this.searchObj.end).format("YYYY-MM-DD HH:mm:ss") : ""
                        // this.ifHigtSearch = true
                    }
                }
                this.selectedTimespan = localStorage.getItem("searchText") || ''
            },
            destroyed: function () {
                dataModel.Pin.unwatch(this.unreadWatch);
                this.unwatchUnconfirmCount();
                im.$off('imclick', this.hideMenu);
                // r
            },
            methods: {
                tips() {
                    if (this.startDate != null) {
                        return false;
                    }
                    common.messageToast({
                        type: 'error',
                        message: im.locale.pin.firstStart
                    });
                },
                createGroup: function () {
                    var userId = im.auth.id;
                    dataModel.User.getBatch([userId], function (errorCode, list) {
                        dialog.newDialogBox(null, list, "created");
                    });
                },
                addFriend: function () {
                    dialog.addFriend();
                },
                addPin: function () {
                    dialog.addPin({});
                },
                goTimespan: function (value) {
                    im.$router.replace({
                        path: '/pin/' + (
                            this.inSentPin ? 'sent' : 'received'
                        ) + value,
                    });
                },
                defaultRoute: function (route) {
                    return '/pin/' + route;
                },
                getResizeDirection: function () {
                    var direction = common.getResizeDirection({
                        range: this.width,
                        bound: this.bound.width,
                        directions: ['left', 'right']
                    });
                    im.resizeDirection.temp = direction;
                    return direction;
                },
                //模糊搜索
                searchPin: function (value) {
                    let path = im.$route.path
                    localStorage.setItem('searchText', value.keyword)
                    localStorage.setItem('ifHight', false)
                    this.selectedTimespan = value.keyword
                    let data = {
                        isHigh: false,
                        data: value.keyword
                    }
                    im.$nextTick(() => {
                        im.$emit('searchPin', data)
                    })
                },
                //高级搜索
                searchHigtPin: function () {
                    let path = im.$route.path
                    // 高级搜索的条件不全部为空
                    if (!checkEmpty(this.searchObj)) {
                        localStorage.setItem("searchObj", JSON.stringify(this.searchObj))
                        im.$nextTick(() => {
                            let data = {
                                isHigh: true,
                                data: this.searchObj
                            }
                            im.$emit('searchPin', data)
                        })
                    } else {
                        common.messageToast({
                            type: 'error',
                            message: '请输入关键字'
                        });
                        return;
                    }


                },
                reload() {
                    this.isRouterAlive = false
                    this.$nextTick(function () {
                        this.isRouterAlive = true
                    })
                }
            },
            watch: {
                selectedTimespan(v) {
                    let data = {
                        isHigh: false,
                        data: v
                    }
                    localStorage.setItem('searchText', v)
                    im.$emit('searchPin', data)
                },
                searchObj: {
                    handler() {
                        localStorage.setItem("searchObj", JSON.stringify(this.searchObj))
                    },
                    deep: true
                },
                ifHigtSearch(v) {
                    let data = {
                        isHigh: v
                    }

                    if (!v) {
                        this.searchObj = {}
                        this.startDate = null
                        this.endDate = null
                        localStorage.removeItem('ifHigtSearch', v)
                    } else {
                        localStorage.setItem('ifHigtSearch', v)
                        if (!checkEmpty(this.searchObj)) {
                            data.data = this.searchObj
                        }
                    }
                    this.selectedTimespan = ''
                    im.$emit('searchPin', data)
                },
                uncommentCount(v) {
                    // 如果是新回复页面
                    // if (im.$route.path.indexOf('newReply') > -1) {
                    //     im.$emit('getNewReplay')
                    // }

                },
                startDate(v){
                    if(!v){
                        return
                    }
                    let that = this;
                    if(that.endDate && that.endDate < v){
                        common.messageToast({
                            type: 'error',
                            message: '开始时间应早于结束时间'
                        });
                        that.startDate = null
                    }

                },
                endDate(v){
                    if(!v){
                        return
                    }
                    let that = this;
                    if(that.startDate && that.startDate > v){
                        common.messageToast({
                            type: 'error',
                            message: '结束时间应晚于结束时间'
                        });
                        that.endDate = null
                    }
                }
            },
        };
        utils.asyncComponent(options, resolve, reject);
    }

    var setupUnReadCount = utils.throttle(function (context, pinApi) {
        // setupReceivedUnReadCount(context, pinApi);
        // setupSentUnReadCount(context, pinApi);
    }, 2000);
    function mounted(context, pinApi, im) {

        var routePath = im.$route.path;
        routePath = routePath.substr(routePath.lastIndexOf('/'));
        // var isSelectedTimespan = context.timespanOptions.some(function (option) {
        //     return (option.value == routePath);
        // });
        // context.selectedTimespan = isSelectedTimespan ? routePath : '';

        context.unreadWatch = function (message) {
            var isCommentMessage = pinApi.MessageType.PinCommentMessage === message.messageType;
            var isCommentReadMessage = pinApi.MessageType.PinCommentReadMessage === message.messageType;
            var loginUser = im.loginUser || {};
            var notSelfComment = isCommentMessage && (message.content.publisherUid !== loginUser.id);
            if (notSelfComment || isCommentReadMessage) {
                setupUnReadCount(context, pinApi);
            }
        };
        pinApi.watch(context.unreadWatch);
        setupUnReadCount(context, pinApi);
        common.resizeNavNode(context, im);

        //待确认
        context.receivedUnReadCount.unConfirm = im.pinUnReadCount.unConfirm;
        context.unwatchUnconfirmCount = im.$watch('pinUnReadCount.unConfirm', function (newVal) {
            context.receivedUnReadCount.unConfirm = newVal;
        });
        context.receivedUnReadCount.unComment = im.pinUnReadCount.unComment;
        context.unwatchUncommentCount = im.$watch('pinUnReadCount.unComment', function (newVal) {
            context.receivedUnReadCount.unComment = newVal;
        });



        context.hideMenu = function () {
            context.isShowMenu = false;
            context.$emit('imclick');
        };
        im.$on('imclick', context.hideMenu);
    }
    // 判断对象的所有属性是否都为空
    function checkEmpty(params) {
        let flag = true
        if (params) {
            for (var key in params) {
                console.log(params[key] != '')
                console.log(params[key])
                if (params[key] && params[key] != '') {
                    flag = false
                    return;
                }

            }
        }

        return flag;
    }
    //日历
    function initDate(context) {
        let param = {
            singleDatePicker: true, //设置为单个的datepicker，而不是有区间的datepicker 默认false
            alwaysShowCalendars: true,
            showDropdowns: true, //当设置值为true的时候，允许年份和月份通过下拉框的形式选择 默认false
            timePicker: true,
            autoApply: true,
            autoUpdateInput: false,
            timePicker24Hour: true,
            opens: 'right',
            locale: {
                applyLabel: '确定',
                cancelLabel: '取消',
                daysOfWeek: ['日', '一', '二', '三', '四', '五', '六'],
                monthNames: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
                firstDay: 0
            }

        }
        // let paramEnd = {
        //     ...param,
        //     minDate:context.searchObj.start
        // }
        $('#start').daterangepicker(param)
            .on('cancel.daterangepicker', function (ev, picker) {
                context.searchObj.start = ''
                context.startDate = ''
            }).on('apply.daterangepicker', function (ev, picker) {
                context.startDate = picker.startDate.format('YYYY-MM-DD HH:mm:ss')
                context.searchObj.start = new Date(context.startDate.replace(new RegExp("-", "gm"), "/")).getTime()
                // $('#end').daterangepicker({
                //         ...param,
                //         minDate: picker.startDate
                //     })
                //     .on('cancel.daterangepicker', function (ev, picker) {
                //         context.searchObj.end = ''
                //         context.endDate = ''
                //     }).on('apply.daterangepicker', function (ev, picker) {
                //         context.endDate = picker.startDate.format('YYYY-MM-DD HH:mm:ss')
                //         context.searchObj.end = new Date(context.endDate.replace(new RegExp("-", "gm"), "/")).getTime()
                //     });

            });
        $('#end').daterangepicker(param)
            .on('cancel.daterangepicker', function (ev, picker) {
                context.searchObj.end = ''
                context.endDate = ''
               
            }).on('apply.daterangepicker', function (ev, picker) {
                context.endDate = picker.startDate.format('YYYY-MM-DD HH:mm:ss')
                context.searchObj.end = new Date(context.endDate.replace(new RegExp("-", "gm"), "/")).getTime()
                // $('#start').daterangepicker({
                //     ...param,
                //     maxDate: picker.startDate
                // })
                // .on('cancel.daterangepicker', function (ev, picker) {
                //     context.searchObj.start = ''
                //     context.startDate = ''
                // }).on('apply.daterangepicker', function (ev, picker) {
                //     context.startDate = picker.startDate.format('YYYY-MM-DD HH:mm:ss')
                //     context.searchObj.start = new Date(context.startDate.replace(new RegExp("-", "gm"), "/")).getTime()
                // });
            });
    }

    function setupReceivedUnReadCount(context, pinApi) {
        pinApi.getInboxUnRead(function (errorCode, unread) {
            if (!errorCode && unread) {
                context.receivedUnReadCount.unComment = unread.length;
            }
        });
    }

    function setupSentUnReadCount(context, pinApi) {
        pinApi.getOutboxUnRead(function (errorCode, response) {
            if (!errorCode && response) {
                // context.sentUnReadCount = response.length;
                let list = response;
                context.sentUnReadCount = list.reduce((result, item) => {
                    return result + item.un_read_comment_count
                }, 0)
            }
        });
    }

    $.extend(true, components, {
        pin: {
            getNav: getNav
        }
    });
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));