(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var $ = dependencies.jQuery;
    var common = RongIM.common;
    var fileApi = RongIM.dataModel.File;
    var debounceDownload = utils.debounce(initDownload, 300);

    function getReplyOrConfirm(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        var system = RongIM.system;
        var options = {
            name: 'pin-received',
            template: 'modules/pin/templates/received.html',
            data: function () {
                return {
                    confirmExpand: false,
                    pinList: [],
                    minTimestamp: 0,
                    hasMore: true,
                    selectedPin: null,
                    isClicking: 0,
                    isLoading: false,
                    searchText: '',
                    ifList: true, //是否显示list模式

                    downloaders: {},
                    attachmentList: [],
                    // startDate: '', //开始时间
                    // endDate: '', //结束时间
                    searchObj: {
                        start: '',
                        end: '',
                        contacts: '',
                        title: '',
                        attachedName: '',
                        content: ''
                    },
                    receivedUnReadCount: {
                        unConfirm: 0,
                        unComment: 0
                    },
                    searchCount: 0,
                    isReplyOrConfirm: true,
                    ifShowDetail: false,
                    ifSearch: false,
                    ifHight: false,
                    higtStyle: {
                        height: 'calc(100% - 105px)',
                        // overflowY: 'auto'
                    },
                    contentHeight: {
                        height: 'calc(100vh - 180px)',
                    },
                    contentHeightMac: {
                        height: 'calc(100vh - 160px)',
                    },
                    showSetting: false,
                    currentNum: 0,
                    currentIndex: 0
                };
            },
            components: {
                avatar: components.getAvatar,
                pinDetail: components.getPinDetail,
                status: components.getStatus,
                pinSearch: components.getPinSearch
            },
            mixins: [getContextMenu()],
            inject: ['reload'], //刷新页面不闪烁
            computed: {
                // 系统是否为win32或者linux
                os: function () {
                    return system.platform === 'win32' || system.platform === 'linux';
                },
                showEmptyPage: function () {
                    return this.pinItems.length === 0;
                },
                unreadReceivedCount: function () {
                    return this.receivedUnReadCount.unConfirm + this.receivedUnReadCount.unComment;
                },
                isConnected: function () {
                    return im.status === utils.status.CONNECTED;
                },
                pinItems: function () {
                    return this.pinList.filter(obj => obj.type == 1)
                    // return this.pinList;
                },
                unconfirmedCount: function () {
                    var count = 0;
                    this.pinItems.forEach(function (pin) {
                        if (!pin.confirmed) ++count;
                    });
                    return count;
                },
                confirmAllBtnStyle: function () {
                    if (this.selectedPin) {
                        return {
                            right: '308px'
                        }
                    }
                    return {};
                },
                isWeb: function () {
                    var platform = utils.getPlatform();
                    var isWeb = platform.indexOf('web') !== -1;
                    return isWeb;
                }
            },
            methods: getMethods(im, dataModel),
            mounted: function () {
                mounted(this, dataModel, im);
            },
            watch: {
                ifHight(v) {
                    if (v) {
                        this.contentHeight.height = 'calc(100vh - 390px)'
                    } else {
                        this.contentHeight.height = 'calc(100vh - 180px)'
                    }

                }
            },
            destroyed: function () {
                pinApi.unwatch(this.pinCreateWatch);
                pinApi.unwatch(this.pinChangeWatch);
                pinApi.unwatch(this.pinDeleteWatch);
            }
        };
        utils.asyncComponent(options, resolve, reject);
    }

    function mounted(context, dataModel, im) {
        var pinApi = dataModel.Pin;
        // initDate(context);

        pinCreateWatch(context, pinApi);
        pinChangeWatch(context, pinApi);
        pinDeleteWatch(context, pinApi);
        watchDeletePin(context);
        watchConnectStatus(context, pinApi);
        setupReceivedUnReadCount(context, pinApi)

        initPinInBox(context, pinApi);

    }

    function initPinInBox(context, pinApi) {
        var loadMore = function () {
            Vue.nextTick(function () {
                if (isScrollToBottom()) setupPinInBox(context, pinApi, context.minTimestamp, loadMore);
            });
        };
        setupPinInBox(context, pinApi, context.minTimestamp, loadMore);
    }
    // 获取为确认条数
    function setupReceivedUnReadCount(context, pinApi) {
        pinApi.getInboxUnRead(function (errorCode, unread) {
            if (!errorCode && unread) {
                context.receivedUnReadCount.unComment = unread.length;
            }
        });
    }

    function getMethods(im, dataModel) {
        var pinApi = dataModel.Pin;
        return {
            formatFileSize: utils.formatFileSize,
            //时间戳转化
            formatDate: function (value) { //value为13位的时间戳
                return moment(value).format('YYYY-MM-DD HH:mm:ss');
            },
            status: function () {
                return im.status;
            },
            //寻呼主题
            getPinTitle: function (pin) {
                if (!pin || !pin.title) {
                    return undefined;
                }
                var title = common.textMessageFormat(pin.title);
                let text = ''
                if (this.ifHight) {
                    text = this.searchObj ? this.searchObj.title : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(title, text);
            },
            //寻呼内容
            getPinContent: function (pin) {
                if (!pin || !pin.content) {
                    return undefined;
                }
                var content = common.textMessageFormat(pin.content);
                let text = ''
                if (this.ifHight) {

                    text = this.searchObj ? this.searchObj.content : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(content, text);
            },
            //寻呼附件名称
            getAttachName: function (attach) {
                if (!attach || !attach.name) {
                    return undefined;
                }
                var name = common.textMessageFormat(attach.name);
                let text = ''
                if (this.ifHight) {
                    text = this.searchObj ? this.searchObj.attachedName : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(name, text);
            },
            //获取接收人
            getReceiverName: function (pin) {
                if (!pin || !pin.receiver_name) {
                    return undefined;
                }
                var name = common.textMessageFormat(pin.receiver_name);
                let text = ''
                if (this.ifHight) {
                    text = this.searchObj ? this.searchObj.contacts : ''
                } else {
                    text = this.searchText
                }
                return common.highlight(name, text);
            },
            userProfile: function (userId) {
                var that = this;
                this.isClicking++;
                dialog.user(userId, function () {
                    that.isClicking--;
                });
            },
            getUsername: function (user) {
                return user ? user.alias || user.name : ' ';
            },
            getConfirmStr: function (pin) {
                var localeReceived = im.locale.components.receivedPin;
                return pin.confirmed ? localeReceived.replyNone : localeReceived.unConfirmed;
            },
            getReplyDetail: function (pin) {
                var localeReceived = im.locale.components.receivedPin;
                var replyPrompt = this.localeFormat(localeReceived.reply, pin.comment_count);
                replyPrompt = pin.comment_count ? replyPrompt : localeReceived.replyNone;
                return pin.confirmed ? replyPrompt : localeReceived.confirmReceived;
            },
            dateFormat: function (pin) {
                let timestamp = pin.send_dt || pin.create_dt
                var dateFormat = utils.dateFormat;
                var options = {
                    alwaysShowTime: true
                };
                return dateFormat(timestamp, options);
            },
            showDetail: function (pin, isReply) {
                let _that = this
                // if (_that.isReplyOrConfirm) {
                //     _that.pinConfirm(pin);
                //     return;
                // }
                if (pin.title !== '已撤回') {
                    // setupPinDetail(_that, pinApi, pin, function (selectPin) {
                    if (!_that.isClicking) {
                        _that.selectedPin = pin;
                        _that.ifShowDetail = true
                        _that.selectedPin.isReply = isReply;
                        pin.un_read_comment_count = 0;
                    }
                    // });
                } else {
                    common.messageToast({
                        type: 'success',
                        message: im.locale.pin.revokePin
                    });
                }

            },
            receiveConfirm: function (pin) {
                if (pin.confirmed) {
                    this.showDetail(pin, true);
                    return;
                }
                var that = this;
                this.isClicking++;
                $.when(setPinConfirm(pin, pinApi))
                    .then(function () {
                        // server 会下发通知消息屏蔽这里重复获取
                        // pinApi.notifyUnReadCount(pin.pinUid);
                    }).fail(function (err) {
                        that.toastError(err);
                    }).always(function () {
                        that.isClicking--;
                    });
            },
            //确认后的回调
            confirmPin: function (pin) {
                //2、状态改为已确认
                this.pinList.forEach((obj, index) => {
                    if (obj.uid == pin.uid) {
                        this.pinList.splice(index, 1);
                    }
                })
                //3.
            },
            //添加回复数量
            addCommentCount: function (pin) {
                this.pinList.forEach(obj => {
                    if (obj.uid == pin.uid) {
                        obj.comment_count += 1;
                    }
                })
            },
            pinConfirm: function (pin) {
                var that = this;
                if (pin.confirmed) {
                    return false;
                }
                pinApi.confirm(pin.uid, function () {
                    pin.confirmed = true;
                    common.messageToast({
                        type: 'success',
                        message: "确认成功"
                    });
                    that.pinList = that.pinList.filter(obj => obj.uid != pin.uid)
                    // setupReceiverConfirm(that, im.loginUser.id);
                    // that.$emit('confirmPin', that.pinUid);
                    // that.inputFocus();
                });
            },
            confirmAll: function () {
                var that = this;
                this.pinItems.forEach(function (pin) {
                    if (!pin.confirmed) {
                        that.receiveConfirm(pin);
                    }
                });
            },
            // 一键确认
            confirmAllOnce: function () {
                let _that = this;
                common.messagebox({
                    message: '确定将这些新寻呼全部置为已确认吗？',
                    type: 'confirm',
                    callback: function () {
                        let ids = {
                            ids: _that.pinList.map(obj => {
                                return obj.uid
                            })
                        }
                        pinApi.confirmAllOnce(ids, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            _that.pinList.splice(0, _that.pinList.length)

                            _that.reload()
                            common.messageToast({
                                type: 'success',
                                message: im.locale.components.pinDetail.allConfirmed
                            });


                        })
                    }
                });



            },
            // forwardPin: function (pin) {
            //     // dialog.forwardPin(pin);
            //     dialog.newForwardPin(pin);
            // },
            confirmAll: function () {
                var that = this;
                this.pinItems.forEach(function (pin) {
                    if (!pin.confirmed) {
                        that.receiveConfirm(pin);
                    }
                });
            },
            hasUnReadComment: function (pin) {
                var isConfirmed = pin.confirmed;
                var isSelected = this.selectedPin === pin;
                return pin.un_read_comment_count && !isSelected && isConfirmed;
            },
            afterEnter: function () {
                this.isClicking = 0;
                im.$emit('pinDetailLoadDone');
            },
            enterCancelled: function () {
                this.isClicking = 0;
            },
            scroll: function () {
                var that = this;
                if (isScrollToBottom()) {
                    setupPinInBox(this, pinApi, that.minTimestamp);
                }
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            closeDetail: function () {
                this.ifShowDetail = false;
                this.forwardPin(this.selectedPin)
            },
            //高级搜索
            searchHigtPin: function () {
                // var loadMore = function () {
                //     Vue.nextTick(function () {
                //         if (isScrollToBottom()) setupPinInBoxHigh(this, pinApi, this.minTimestamp, loadMore);
                //     });
                // };
                setupPinInBoxHigh(this, pinApi, this.minTimestamp, false);
            },
            //模糊搜索
            searchPin: function (opt) {
                this.searchText = opt;
                var loadMore = function () {
                    Vue.nextTick(function () {
                        if (isScrollToBottom()) setupPinInBoxeSearch(this, pinApi, this.minTimestamp, loadMore);
                    });
                };
                setupPinInBoxeSearch(this, pinApi, this.minTimestamp, loadMore);
            },
            getFileIconClass: function (name) {
                var prefix = 'rong-pin-file-';
                var getPointTotal = name.split('.').length - 1;
                var splitArr = name.split('.');
                return prefix + splitArr[getPointTotal];
            },
            clipboard: function (text, event) {
                const clipboard = new ClipboardJS(event.target, {
                    text: () => text
                })
                let that = this;
                clipboard.on('success', (e) => {
                    clipboard.destroy()
                    common.messageToast({
                        type: 'success',
                        message: that.locale.copyFileUrl.success
                    });
                })
                clipboard.on('error', (e) => {
                    clipboard.destroy()
                    common.messageToast({
                        type: 'error',
                        message: that.locale.copyFileUrl.error
                    });
                })
                clipboard.onClick(event)
            },
            // click copy content
            copy: function (attach, event) {
                let arr1 = attach.url.split('?') //arr1[0]=?前的路径
                let arr2 = arr1[0].split('/') //arr2[arr2.length-1] = 要取的字符串
                arr2[arr2.length - 1] = attach.name //替换文件名
                let str1 = arr2.join('/') //拼接字符串 str1= arr1[0] 也就是 ?前的路径
                arr1[0] = str1;
                let url = arr1.join('?') //拼接arr1就是完整url
                let code = utils.encryptCode(url);
                // url = "https://work.cast.org.cn/modules/redirect.html?down=" + encodeURIComponent(code)
                this.clipboard(url, event);
            },

            download: function (attach, list, index, num, isResume) {
                let count = attach.name.lastIndexOf(".");
                attach.rename = this.insertStr(attach.name, count, '_' + attach.uid);

                if (isResume) {
                    if (this.downloader) {
                        this.pinList[index].attachments[num].isDownloading = true;
                        this.pinList[index].attachments[num].isCanceled = false;
                        this.downloader.resume();
                    }
                    return;
                }
                let locaPath = RongIM.downloader.getSaveFolder();
                if (!locaPath) {
                    debounceDownload(attach, list, index, num, this, isResume);
                    return
                };

                RongIM.downloader.doesItExistLocaPath(locaPath).then((res) => {
                    let isFile = RongIM.downloader.getFileList(locaPath).some((item) => {
                        return attach.name == item;
                    })
                    if (isFile) {
                        this.repeatFile(locaPath, attach, list, index, num);
                    } else {
                        debounceDownload(attach, list, index, num, this, isResume);
                    }
                }).catch(err => {
                    RongIM.downloader.removeSaveFolder();
                    debounceDownload(attach, list, index, num, this, isResume);
                })
            },
            /**
             * 字符串指定位置插入
             * @param {String} soure  原字符串
             * @param {Number} start  将要插入得位置
             * @param {String} newStr 要插入的字符
             */
            insertStr(soure, start, newStr) {
                return soure.slice(0, start) + newStr + soure.slice(start);
            },

            // 重复文件处理
            repeatFile(locaPath, attach, list, index, num, isResume) {
                let count = attach.name.lastIndexOf(".");
                for (let i = 1; i < RongIM.downloader.getFileList(locaPath).length; i++) {
                    if (RongIM.downloader.getFileList(locaPath).indexOf(this.insertStr(attach.name, count, "(" + i + ")")) == -1) {
                        let name = this.insertStr(attach.name, count, "(" + i + ")");
                        i = RongIM.downloader.getFileList(locaPath).length;
                        attach.name = name;
                    }
                }

                debounceDownload(attach, list, index, num, this, isResume);
                common.messageToast({
                    message: "文件保存为" + attach.name,
                    type: 'success'
                });
            },
            // 暂停
            pauseDownload: function (attach, index, num) {
                if (this.downloader) {
                    this.downloader.pause();
                }
                let pinObj = this.pinList[index].attachments[num]
                pinObj.isCanceled = true;
                pinObj.isDownloading = false;
                this.pinList[index].attachments.splice(num, 1, pinObj);
            },
            cancelDownload: function (url, attach) {
                var currentDownload = this.downloaders[url];
                if (currentDownload) {
                    attach.isCanceled = true;
                    attach.isDownloading = false;
                    currentDownload.abort();
                }
            },
            openFolder: openFolder,
            forwardPin: function (pin) {
                let _that = this
                let msg = {
                    forWard: true,
                    pin: pin
                }
                dialog.addPin(msg);

            },
            //修改附件状态
            changeAttachStatus: function (data) {
                let _that = this
                Vue.nextTick(function () {
                    _that.pinList.filter(obj => obj.uid == data.uid)[0].attachments[data.index].downloadProgress = 100

                })

            },
            //显示包含搜索关键字
            showKeyword: function (pin) {
                let content = pin.content;
                let textContain = content.includes(this.searchText)
                let objContain = (this.searchObj && this.searchObj.content != "") ? content.includes(this.searchObj.content) : false;
                //包含搜索关键字
                let contain = textContain || objContain
                return this.ifSearch && contain

            },
            keywordLabel: function () {
                let kayword = this.ifHight ? this.searchObj.content : this.searchText;
                return this.localeFormat(im.locale.pin.containKey, kayword);
            },
            isAssetTypeAnImage: function (name) {
                let index = name.lastIndexOf(".");
                return utils.isAssetTypeAnImage(name.substr(index + 1))
            },
            //判断打开文件还是下载
            downloadOrOpen: function (attach, attachments, index, num) {
                let that = this;
                if (attach.isClick) {
                    return false;
                }
                if (!attach.isDownloading && attach.downloadProgress === 0) {
                    attach.isClick = true
                    that.download(attach, attachments, index, num)
                } else if (!attach.isDownloading && attach.downloadProgress === 100) {
                    this.openFolder(attach, true)
                } else {
                    return false
                }

            },
            enter(index, num) {
                this.showSetting = true;
                this.currentIndex = index;
                this.currentNum = num;
            },
            leave() {
                this.showSetting = false;
                this.currentNum = null;
                this.currentIndex = null;
            },
            saveAs(event, attach) {
                console.log(event);
                let arr1 = attach.url.split('?') //arr1[0]=?前的路径
                let arr2 = arr1[0].split('/') //arr2[arr2.length-1] = 要取的字符串
                arr2[arr2.length - 1] = attach.name //替换文件名
                let str1 = arr2.join('/') //拼接字符串 str1= arr1[0] 也就是 ?前的路径
                arr1[0] = str1;
                let url = arr1.join('?') //拼接arr1就是完整url
                console.log(url);
                event.target.href = url
                // event.target.href = attach.url
            },
            _click() {
                return false;
            },
            remind: function (pin) {
                var dialog = RongIM.dialog;
                const dataObj = {
                    data: pin,
                    type: 'pin'
                }
                dialog.addChooseDate(dataObj)
                // dialog.addChooseDate(pin)
            },
            // 转日程
            gotoSchedule(pin) {
                var loginInfo = utils.cache.get('loginInfo');
                var link = 'http://219.142.112.25/skd-web-pc/index.html?useValidation=1#/third_login';
                let url = ''
                if (loginInfo && loginInfo.zkxToken) {
                    var token = decodeURIComponent(loginInfo.zkxToken) + ';path=/';
                    if (loginInfo.RCESESSIONID) {
                        link += "?pinId=" + pin.uid + '&userId=' + im.loginUser.id + "&sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                            "&uid=RY" + loginInfo.zkxEmpId
                    }
                    url = RongIM.config.loginServer + '/sign-bridge.html' + '?target=' + encodeURIComponent(link) +
                        '&token=' + encodeURIComponent(token);
                }
                RongIM.browserWindow.openPSArticle(url)
                // RongDesktop.browserWin.create({
                //     width:1000,
                //     minWidth: 800,
                //     path: url,
                // });
                // window.open(url);
            },
            // 转任务
            gotoTask(pin) {
                var loginInfo = utils.cache.get('loginInfo');
                var link = 'http://219.142.112.25/ttsms-web-pc/index.html?useValidation=1#/third_login';
                let url = ''
                if (loginInfo && loginInfo.zkxToken) {
                    var token = decodeURIComponent(loginInfo.zkxToken) + ';path=/';
                    if (loginInfo.RCESESSIONID) {
                        link += "?pinId=" + pin.uid + '&userId=' + im.loginUser.id + "&sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                            "&uid=RY" + loginInfo.zkxEmpId
                    }
                    url = RongIM.config.loginServer + '/sign-bridge.html' + '?target=' + encodeURIComponent(link) +
                        '&token=' + encodeURIComponent(token);
                }
                RongIM.browserWindow.openPSArticle(url)
                // RongDesktop.browserWin.create({
                //     width:1000,
                //     minWidth: 800,
                //     path: url,
                // });
                // window.open(url);
            },
            // 删除寻呼
            delPin(pin) {
                let that = this
                common.messagebox({
                    message: '确定删除该条寻呼吗？',
                    type: 'confirm',
                    callback: function () {
                        that.ifShowDetail = false
                        //先取消寻呼
                        pinApi.cancelPin(pin.uid, function (errorCode, res) {
                            // if(errorCode){
                            //     return;
                            // }
                            // if(res.code !='10000'){
                            //     return;
                            // }
                            //删除寻呼
                            pinApi.deletePin(pin.uid, function (error, res) {
                                if (error) {
                                    return;
                                }
                                common.messageToast({
                                    type: 'success',
                                    message: "删除成功"
                                });
                                //将寻呼在列表中删除
                                that.pinList.splice(that.pinList.findIndex(item => item.uid === pin.uid), 1)
                                that.searchCount -= 1
                            })
                        })
                    }
                });
            }
        };
    }

    function setupPinAttachmentList(context, list, pinApi, uid, pinList, index) {
        var progress = {
            isDownloading: false,
            downloadProgress: 0,
            isCanceled: false
        };
        list = list.map(function (attach) {
            return $.extend(attach, progress);
        });
        list = list.map(function (atta) {
            var imageUrl = '//rongcloud-image.';
            var fileUrl = '//rongcloud-file.';
            if (atta.url.indexOf(imageUrl) === -1 && atta.url.indexOf(fileUrl) === -1) {
                atta.url = atta.url + '?attname=' + encodeURI(atta.name);
            }
            var downloadSize = loadDownloadStat(atta.uid);
            if (downloadSize) {
                atta.isCanceled = true;
                atta.downloadProgress = (downloadSize / atta.size) * 100;
            }
            //判断本地是否存在,
            let count = atta.name.lastIndexOf(".");
            let name = context.insertStr(atta.name, count, '_' + atta.uid);
            var localPath = pinApi.getPinLocalAttach(name);
            var fileExist = RongIM.file.checkExist(localPath);
            if (fileExist) {
                atta.rename = name;
            }
            return atta;
        });
        context.attachmentList = list;

        setupAttachDownload(context, pinList, index);
        setupAttachExists(context.attachmentList);
    }

    function setupAttachExists(attachmentList) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        attachmentList.forEach(function (attach) {
            setAttach(attach);
        });

        function setAttach(attach) {
            var localPath = pinApi.getPinLocalAttach(attach.rename);
            var fileExist = RongIM.file.checkExist(localPath);
            if (fileExist) {
                attach.localPath = localPath;
                attach.downloadProgress = 100;
            }
        }
    }

    function loadDownloadStat(uId) {
        var fileState = RongIM.downloader.getProgress(uId);
        if (fileState.offset) {
            return fileState.offset;
        }
        return 0;
    }


    function initDownload(attach, pinList, index, num, _that, isResume) {
        /* var file = {url: fileUrl};
        var downloader = RongIM.download(file); */
        fileApi.getFileDownloadToken(function (error, token) {
            if (error) {
                common.toastError('download-error');
                return;
            }
            var url = attach.url;
            if (url.indexOf('?') !== -1) {
                url += '&token=' + token;
            } else {
                url += '?token=' + token;
            }
            var file = {
                url: url,
                name: attach.rename,
                size: attach.size,
                uId: attach.uid
            };
            var downloader = RongIM.downloader.load(file);

            downloader.onError = function () {

                // stateCode = ('download-' + params.state);
                // context.isDownloading = false;
                // context.isCanceled = true;
                // context.downloadProgress = 0;
                // common.handleError(stateCode);
            };

            // 下载准备完毕, 此时可知文件大小
            downloader.onReady = function (data) {
                _that.downloader = downloader;
                Vue.nextTick(function () {
                    console.debug('full size:' + data.total);
                    let pinObj = _that.pinList[index]
                    pinObj.isDownloading = true
                    pinObj.isCanceled = false
                    _that.pinList.splice(index, 1, pinObj);
                })
            };

            // 下载中,返回下载进度
            downloader.onProgress = function (data) {
                Vue.nextTick(function () {
                    let pinObj = _that.pinList[index].attachments[num]
                    pinObj.isDownloading = true
                    pinObj.isCanceled = false
                    // pinObj.uploadStatus = 1
                    pinObj.loaded = data.loaded
                    attach.downloadProgress = (data.loaded / data.total) * 100 > 100 ? 100 : (data.loaded / data.total) * 100;
                    _that.pinList[index].attachments.splice(num, 1, pinObj);
                })
            };

            // 下载完成
            downloader.onComplete = function (data) {
                Vue.nextTick(function () {
                    let pinObj = _that.pinList[index].attachments[num]
                    pinObj.isDownloading = false
                    attach.isClick = false;
                    _that.pinList[index].attachments.splice(num, 1, pinObj);
                })
                if (!data.path) {
                    return;
                }
                attach.localPath = data.path;
                // attach.name = attach.rename
                saveLocalAttach(attach, data.path);

            };

            // 下载取消
            downloader.onCancel = function () {
                // context.isDownloading = false;
                // context.isCanceled = false;
                // context.downloadProgress = 0;
                Vue.nextTick(function () {
                    let pinObj = _that.pinList[index].attachments[num]
                    pinObj.isDownloading = false
                    pinObj.isCanceled = false;
                    pinObj.isClick = false;
                    pinObj.downloadProgress = 0;
                    _that.pinList[index].attachments.splice(num, 1, pinObj);
                })
                attach.downloader = {};
            };
            // context.downloadStatus = 'DOWNLOADING';
            //继续
            if (isResume) {
                downloader.continue();
                return;
            }
            downloader.saveAs();

            // attach.downloaders[attach.url] = downloader;
        });
    }

    function removeLocalAttach(attach) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        pinApi.removeLocalAttach(attach.rename);
    }

    function saveLocalAttach(attach, localPath) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        pinApi.addPinLocalAttach(attach.rename, localPath);
    }

    function setupAttachDownload(context, pinList, index) {
        context.attachmentList.forEach(function (attach, num) {
            attach.downloaders = context.downloaders;
            // initDownload(attach, attach.url, pinList, index, num, context);
        });
    }

    function openFolder(attach, isClickName) {
        var file = RongIM.file;
        var localPath = attach.localPath;
        var fileExist = file.checkExist(localPath);
        if (attach.isDownloading && fileExist) {
            return;
        }
        if (localPath && fileExist) {
            if (isClickName) {
                file.open(localPath);
            } else {
                file.openDir(localPath);
            }
        } else {
            common.toastError('file-404');
            attach.downloadProgress = 0;
            removeLocalAttach(attach);
        }
    }

    function getContextMenu() {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        var options = {
            template: 'modules/pin/templates/deletepin-contextmenu.html',
            methods: {
                deletePin: function () {
                    var that = this;
                    var pin = this.context.pin;
                    pinApi.deletePin(pin.uid, function () {
                        that.$emit('close');
                        im.$emit('deletePin', pin);
                        pinApi.notifyUnReadCount();
                    });
                }
            }
        };
        return components.getContextMenu(options);
    }

    function watchDeletePin(context) {
        var im = RongIM.instance;
        im.$on('deletePin', function (pin) {
            context.pinList = context.pinList.filter(function (pinDetail) {
                return pinDetail.uid !== pin.uid;
            });
        });
    }

    function watchConnectStatus(context, pinApi) {
        var im = RongIM.instance;
        im.$watch('status', function (status) {
            if (status === utils.status.CONNECTED) {
                setupPinInBox(context, pinApi, context.minTimestamp);
            }
        });
    }

    var throttleMap = {};

    function setupPinDetailThrottle(context, pinApi, pin, callback) {
        // var uid = pin.uid;
        // var later = function () {
        //     throttleMap[uid] = {
        //         args: [],
        //         handle: function () {
        //             throttleMap[uid] = null;
        //         }
        //     };
        //     setTimeout(function () {
        //         var th = throttleMap[uid];
        //         if (th) {
        //             th.handle.apply(null, th.args);
        //         }
        //     }, 2000);
        // };
        // var throttle = throttleMap[uid];
        // if (throttle) {
        //     throttle.args = arguments;
        //     throttle.handle = function () {
        //         setupPinDetail.apply(null, arguments);
        //         later();
        //     };
        // } else {
        setupPinDetail(context, pinApi, pin, callback);
        //     later();
        // }
    }

    function setupPinDetail(context, pinApi, pin, callback) {
        pinApi.getPinDetail(pin.uid, function (errorCode, detail) {
            if (errorCode) {
                return;
            }
            // delete detail.attachments
            $.extend(pin, detail);
            if (callback) callback(detail);
        });
    }

    function pinCreateWatch(context, pinApi) {
        var im = RongIM.instance;
        context.pinCreateWatch = function (message) {
            if (message.messageType === pinApi.MessageType.PinNotifyMessage) {
                var pinCreaterId = message.content.creatorUid;
                var pinIdList = context.pinList.map(function (pin) {
                    return pin.uid;
                });
                var msgContent = message.content || {};
                var isNewPin = pinIdList.indexOf(msgContent.pinUid) === -1;
                if (pinCreaterId === im.loginUser.id || !isNewPin) {
                    return;
                }
                message.content.uid = message.content.pinUid;
                setupPinDetailThrottle(context, pinApi, message.content, function (pin) {
                    var list = context.pinList.concat([]);
                    list.unshift(pin);
                    context.pinList = deleteRepeatPin(list);
                });
            }
        };
        pinApi.watch(context.pinCreateWatch);
    }

    function pinChangeWatch(context, pinApi) {
        context.pinChangeWatch = function (message) {
            var isCommentMessage = message.messageType === pinApi.MessageType.PinCommentMessage;
            var isUnReadMessage = message.messageType === pinApi.MessageType.PinCommentReadMessage;
            var isConfirmMessage = message.messageType === pinApi.MessageType.PinConfirmMessage;
            if (isCommentMessage || isUnReadMessage || isConfirmMessage) {
                context.pinList.forEach(function (pin, index) {
                    if (pin.uid === message.content.pinUid) context.pinList.splice(index, 1);
                });
            }
        };
        pinApi.watch(context.pinChangeWatch);
    }

    function pinDeleteWatch(context, pinApi) {
        context.pinDeleteWatch = function (message) {
            var isDeleteMessage = message.messageType === pinApi.MessageType.PinDeletedMessage;
            if (isDeleteMessage) {
                context.pinList = context.pinList.filter(function (pin) {
                    return pin.uid !== message.content.pinUid;
                });
            }
        };
        pinApi.watch(context.pinDeleteWatch);
    }

    function isScrollToBottom() {
        var $el = $('.rong-main-content');
        if (!$el) return false;
        var bottom = $el.css('padding-bottom');
        if (!bottom) return false;
        bottom = parseFloat(bottom.split('px')[0]);
        var scrollTop = $el[0].scrollTop;
        var height = $el.height();
        var scrollHeight = $el[0].scrollHeight;
        return scrollTop + height >= scrollHeight - bottom - 100;
    }

    function setupPinInBox(context, pinApi, timestamp, callback) {
        if (!context.hasMore || context.isLoading) {
            return;
        }
        context.isLoading = true;
        pinApi.getInboxUnconfirm(function (errorCode, result) {
            context.isLoading = false;
            if (errorCode) {
                return;
            }
            context.pinList = result;
            var count = context.pinList.length;
            if (count) {
                context.hasMore = false;
                context.pinList.forEach((obj, index) => {
                    if (obj.attachment_count > 0) {
                        setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, result.data, index);
                    }
                })
                if (callback) callback();
            }


        });
    }
    //高级搜索
    function setupPinInBoxHigh(context, pinApi, timestamp, callback) {
        if (!context.hasMore || context.isLoading) {
            return;
        }
        let param = {
            attachedName: context.searchObj.attachedName,
            contacts: context.searchObj.contacts,
            title: context.searchObj.title,
            content: context.searchObj.content,
            start: context.searchObj.start,
            end: context.searchObj.end
        }
        context.isLoading = true;
        pinApi.pcAccurateSearchInbox(param, function (errorCode, result) {
            context.isLoading = false;
            if (errorCode) {
                return;
            }
            context.pinList = result.data.filter(obj => !obj.confirmed);
            context.searchCount = context.pinList.length;
            if (context.searchCount) {
                context.hasMore = result.total_count > result.count;
                context.minTimestamp = context.pinList[count - 1].send_dt;
                if (callback) callback();
            }
            context.pinList.forEach((obj, index) => {
                if (obj.attachment_count > 0) {
                    setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, result.data, index);
                }
            })
        })
    }
    // 模糊搜索
    function setupPinInBoxeSearch(context, pinApi, timestamp, callback) {
        if (!context.hasMore || context.isLoading) {
            return;
        }
        context.isLoading = true;
        pinApi.mobileSearchInbox(context.searchText, function (errorCode, result) {
            context.isLoading = false;
            if (errorCode) {
                return;
            }
            context.pinList = result.data.filter(obj => !obj.confirmed);
            context.searchCount = context.pinList.length;
            if (context.count) {
                context.hasMore = false;
                // context.minTimestamp = context.pinList[count - 1].send_dt;
                if (callback) callback();
            }
            context.pinList.forEach((obj, index) => {
                if (obj.attachment_count > 0) {
                    setupPinAttachmentList(context, obj.attachments, pinApi, obj.uid, result.data, index);
                }
            })
        })
    }

    function setPinConfirm(pin, pinApi) {
        var $def = $.Deferred();
        pinApi.confirm(pin.uid, function () {
            pin.confirmed = true;
            $def.resolve();
        }, function (err) {
            $def.reject(err);
        });

        return $def;
    }

    function deleteRepeatPin(pinList) {
        var newList = [];
        for (var i = 0; i < pinList.length; i += 1) {
            var pin = pinList[i];
            var newPinUid = newList.map(function (newPin) {
                return newPin.uid;
            });
            if (newPinUid.indexOf(pin.uid) === -1) {
                newList.push(pin);
            }
        }
        return newList;
    }

    $.extend(true, components, {
        pin: {
            getReplyOrConfirm: getReplyOrConfirm
        }
    });
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));