(function (win, dependencies) {
'use strict';

var $ = dependencies.jQuery;
var RongDesktop = dependencies.RongDesktop;
var targetId;
var sessionId;
var isMax = false;
var isConfirmClose = false;

init();

// 点关闭时, 弹出确定提示框
var promptHandler = {
    id: 'prompt',
    getDom: function () {
        return $('#' + promptHandler.id);
    },
    show: function () {
        promptHandler.getDom().show();
    },
    hide: function () {
        promptHandler.getDom().hide();
    },
    confirm: function () {
        isConfirmClose = true;
        RongDesktop.Ipc.send('remote-control-reject', targetId, sessionId);
        RongDesktop.Win.close();
    },
    cancel: function () {
        promptHandler.hide();
    }
};

function init() {
    var queryObj = getQueryObj();
    var title = queryObj.title;
    targetId = queryObj.targetId;
    sessionId = queryObj.sessionId;
    var locale = queryObj.locale;
    setTitle(title);
    showTopBar();
    bindAccept();
    bindReject();
    bindWindowOpt();
    bindPrompt();
    watchTitleChange();
    setPromptText(locale);
    bindCloseWin();
}

function showTopBar() {
    if (isWindows()) {
        $('.rem-top').show();
    }
}

function setTitle(title) {
    $('#title').text(title);
}

// 点击接受
function bindAccept() {
    $('#accept').click(function () {
        isConfirmClose = true;
        RongDesktop.Win.close();
        RongDesktop.Ipc.send('remote-control-accept', targetId, sessionId);
    });
}

// 点击拒绝
function bindReject() {
    $('#reject').click(function () {
        isConfirmClose = true;
        RongDesktop.Win.close();
        RongDesktop.Ipc.send('remote-control-reject', targetId, sessionId);
    });
}

// 关闭窗口监听
function bindCloseWin() {
    win.onbeforeunload = function () {
        promptHandler.show();
        if (!isConfirmClose) {
            return false;
        }
        return undefined;
    };
    RongDesktop.Ipc.register('remote-control-close', function () {
        isConfirmClose = true;
        RongDesktop.Win.close();
    });
}

// 提示弹框中的按钮点击
function bindPrompt() {
    $('#confirm').click(function () {
        promptHandler.confirm();
    });
    $('#cancel').click(function () {
        promptHandler.cancel();
    });
}

// 点击放大, 缩小, 关闭窗口按钮
function bindWindowOpt() {
    $('#max').click(function () {
        if (isMax) {
            RongDesktop.Win.restore();
        } else {
            RongDesktop.Win.max();
        }
        isMax = !isMax;
    });
    $('#min').click(function () {
        RongDesktop.Win.min();
    });
    $('#close').click(function () {
        RongDesktop.Win.close();
    });
}

function getQueryString(name) {
    var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
    var r = window.location.search.substr(1).match(reg);// 获取url中"?"符后的字符串并正则匹配
    var context = '';
    if (r != null) {
        context = r[2];
    }
    reg = null;
    r = null;
    // eslint-disable-next-line eqeqeq
    return context == null || context == '' || context == 'undefined' ? '' : context;
}

function isWindows() {
    return RongDesktop.platform !== 'darwin';
}

function watchTitleChange() {
    RongDesktop.Ipc.register('change-remote-title', function (title) {
        setTitle(title);
    });
}

function getQueryObj() {
    var title = getQueryString('title');
    var tarId = getQueryString('targetId');
    var sesId = getQueryString('sessionId');
    var locale = getQueryString('locale');
    return {
        title: decodeURIComponent(title),
        targetId: decodeURIComponent(tarId),
        sessionId: decodeURIComponent(sesId),
        locale: decodeURIComponent(locale)
    };
}

function setPromptText(locale) {
    locale = RongIM.locale[locale];
    $('#reject').text(locale.reject);
    $('#accept').text(locale.accept);
    $('#promptTitle').text(locale.prompt);
    $('#closePrompt').text(locale.closePrompt);
    $('#cancel').text(locale.cancel);
    $('#confirm').text(locale.confirm);
}
}(window, {
    jQuery: jQuery,
    RongDesktop: RongDesktop,
    RongIM: RongIM
}));
