(function(RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var $ = dependencies.jQuery;
    var pageNum = RongIM.config.profile.pageNum;

    function getStar(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var starApi = dataModel.Star;
        var userApi = dataModel.User;

        var options = {
            name: 'contact-star',
            template: 'modules/star/templates/star.html',
            data: function() {
                return {
                    isLoadDone: false,
                    stars: [],
                    pageNum: pageNum,
                    currentPage: 1
                };
            },
            mounted: function() {
                mounted(this, starApi, userApi);
            },
            destroyed: function() {
                cleanup(this, starApi, userApi);
            },
            computed: {
                showEmptyStar: function() {
                    return this.stars.length === 0;
                },
                pageList: function() {
                    var _list = this.stars;
                    var end = this.currentPage * this.pageNum;
                    return _list.slice(0, end);
                }
            },
            methods: {
                getUsername: common.getUsername,
                userProfile: dialog.user,
                loadMore: function() {
                    loadMore(this);
                }
            },
            components: {
                avatar: components.getAvatar
            }
        };
        utils.asyncComponent(options, resolve, reject);
    }

    function mounted(context, starApi, userApi) {
        getList(context, starApi);
        context.userChanged = function() {
            getList(context, starApi);
        };
        userApi.watch(context.userChanged);
        starApi.watch(context.userChanged);
    }

    function getList(context, starApi) {
        starApi.getList(function(errorCode, list) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            context.stars = list;
            context.isLoadDone = true;
        });
    }

    function cleanup(context, starApi, userApi) {
        starApi.unwatch(context.userChanged);
        userApi.watch(context.userChanged);
    }

    function loadMore(context) {
        var end = context.currentPage * context.pageNum;
        var list = context.stars;
        if (list && list.length > end) {
            context.currentPage += 1;
        }
    }
    $.extend(true, components, {
        contact: {
            getStar: getStar
        }
    });
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));