(function (RongWork) {
'use strict';

// eslint-disable-next-line global-require
var nw = require('nw.gui');
var nwwin = nw.Window.get();

function noop() {}
window.openExternal = function(url) {
    if (nw.Shell) {
        nw.Shell.openExternal(url);
    } else {
        var a = document.createElement('A');
        a.target = '_blank';
        a.href = url;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
}

RongWork.browserWindow = {
    max: function () {
        nwwin.maximize();
    },
    min: function () {
        nwwin.minimize();
    },
    restore: function () {
        nwwin.restore();
    },
    close: function () {
        nwwin.close();
    },
    focus: function () {
        nwwin.focus();
    },
    getPlatform: function () {
        return 'win32';
    },
    enterPublic: noop,
    onEnterPublic: noop,
    onCommandClose: noop,
    onPublicNotify: noop,
    reloadWork: noop
};
}(window.RongWork));
