(function (RongWork,RongDesktop) {
    'use strict';
    window.openExternal = function (url, openChrome) {
        // 
        if (openChrome) {
            function cpuArch() {
                var ua = navigator.userAgent.toLowerCase();
                if (ua.indexOf('win64') > -1 || ua.indexOf('wow64') > -1 || ua.indexOf('x86_64') > -1) {
                    return '64';
                }
                return '32';
            }
            var cmd = '';
            [
                "%LocalAppData%",
                "%ProgramFiles(x86)%",
                "%ProgramFiles%"
            ].forEach(function (sysPath) {
                if (cmd) cmd += ' ELSE ';
                cmd += 'IF EXIST "' + sysPath + '\\Google\\Chrome\\Application\\chrome.exe" (ECHO 1)';
            });
            [
                "%AppData%",
                "%AllUsersProfile%"
            ].forEach(function (sysPath) {
                cmd += ' ELSE IF EXIST "' + sysPath + '\\Microsoft\\Windows\\Start Menu\\Google Chrome" (ECHO 1)';
            });
            RongDesktop.child_process.exec(cmd, {
                shell: 'CMD'
            }, function (err, stdout, stderr) {
                console.info(cmd + ': ' + stdout);
                if (stdout && stdout.charAt(0) == '1') {
                    var arch = cpuArch();
                    console.info('cpuArch: ' + arch);
                    RongDesktop.child_process.spawn('start', [
                        'chrome.exe', '--no-sandbox',
                        '--register-pepper-plugins="%ProgramFiles' + (arch == '64' ? '(x86)' : '') + '%\\KGChromePlugin\\KGChromePlugin_' + arch + '.dll;application/kg-plugin"',
                        '--new-window', '"' + url + '"'
                    ], {
                        shell: 'CMD'
                    });
                } else {
                    RongDesktop.shell.openExternal(url);
                }
            });
        } else {
            RongDesktop.shell.openExternal(url);
        }
    }

    RongWork.browserWindow = {
        max: function () {
            RongDesktop.Win.max();
        },
        min: function () {
            RongDesktop.Win.min();
        },
        restore: function () {
            RongDesktop.Win.restore();
        },
        close: function () {
            RongDesktop.Win.close();
        },
        focus: function () {
            RongDesktop.Win.focus();
        },
        getPlatform: function () {
            return RongDesktop.platform;
        },
        enterPublic: function (params, callback) {
            RongDesktop.Win.enterPublic(params, callback);
        },
        onEnterPublic: function (callback) {
            RongDesktop.ipcRenderer.on('openWorkPage', function (event, params) {
                callback(params);
            });
        },
        onCommandClose: function (callback) {
            RongDesktop.ipcRenderer.on('close', function () {
                callback();
            });
        },
        onPublicNotify: function (callback) {
            RongDesktop.ipcRenderer.on('closeApp', function (event, params) {
                callback(params);
            });
        },
        reloadWork: function (callback) {
            RongDesktop.ipcRenderer.on('reload', function (event, params) {
                callback(params);
            });
        },
        openPSArticle: function (url) {
            var querystr = RongIM.utils.getQuerystr({
                zkxToken: RongWork.utils.getQueryString("zkxToken"),
                empId: RongWork.utils.getQueryString("empId") || '',
                sessionid: RongWork.utils.getQueryString("sessionid"),
                url: url
            });
            RongDesktop.BrowserWin.create({
                width: 1000,
                minWidth: 600,
                path: '/modules/publicservice-article/index.html?' + querystr,
                isLocal: true,
            });
        }
    };
    /*
    RongDesktop.Win.on('maximize', function () {
        if (RongWork.instance) {
            RongWork.instance.isMaxWindow = true;
        }
    });
    RongDesktop.Win.on('unmaximize', function () {
        if (RongWork.instance) {
            RongWork.instance.isMaxWindow = false;
        }
    });
    */
}(window.RongWork,window.RongDesktop));