(function (RongIM, RongWork) {
    'use strict';
    var system = RongIM.system;
    var cache = (function () {
        /*
        说明：
        1: JSON.stringfy --> set --> get --> JSON.parse
        2: data format well return as set`s
        3: undefined in array will be null after stringfy+parse
        4: NS --> namespace 缩写
        */
        var keyNS = 'rong-default-';

        function hasOwnProperty(target, key) {
            return Object.prototype.hasOwnProperty.call(target, key);
        }

        function get(key) {
            /*
            legal data: "" [] {} null flase true

            illegal: undefined
                1: key not set
                2: key is cleared
                3: key removed
                4: wrong data format
            */
            key = localStorage.getItem("rong_appId") + key;
            if (!isKeyExist(key)) {
                return undefined;
            }
            // maybe keyNS could avoid conflict
            var val = localStorage.getItem(key) || sessionStorage.getItem(key);
            val = JSON.parse(val);
            // val format check
            if (val !== null && hasOwnProperty(val, 'type') && hasOwnProperty(val, 'data')) {
                return val.data;
            }
            /*
            how to return illegal data for im？
            */
            return undefined;
        }
        // isPersistent
        function set(key, val, isTemp) {
            var store = localStorage;
            if (isTemp) {
                store = sessionStorage;
            }
            key = keyNS + key;
            var type = (typeof val);
            val = {
                data: val,
                type: type
            };
            store[key] = JSON.stringify(val);
        }

        function remove(key) {
            key = keyNS + key;
            localStorage.removeItem(key);
            sessionStorage.removeItem(key);
        }

        function isKeyExist(key) {
            // do not depend on value cause of ""和0
            return hasOwnProperty(localStorage, key) || hasOwnProperty(sessionStorage, key);
        }

        function setKeyNS(NS) {
            if (isString(NS) && NS !== '') {
                keyNS = NS;
            }
        }

        function onchange(callback) {
            callback = callback || $.noop;
            $(window).on('storage', function (e) {
                var event = e.originalEvent;
                if (isEmpty(event.key)) {
                    return;
                }
                var key = event.key.slice(keyNS.length);
                var value = get(key);
                callback(key, value);
            });
        }
        return {
            setKeyNS: setKeyNS,
            get: get,
            set: set,
            remove: remove,
            onchange: onchange
        };
    }());

    function encodeURIArray(value) {
        return value.split(',').map(function (val) {
            return encodeURIComponent(val);
        }).join(',');
    }
    // 获取路径参数
    function getQueryString(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        console.log(window.location.href);
        if (r != null) return unescape(r[2]);
        return null;
    }

    function getQuerystr(obj) {
        var str = '';
        $.each(obj, function (key, value) {
            str += key + '=' + (
                (typeof value === 'string') ? encodeURIArray(value) : encodeURIComponent(value)
            ) + '&';
        });
        return str.substring(0, str.length - 1);
    }

    function templateFormat(source, params) {
        var undef;
        if (arguments.length === 1) {
            return function () {
                var args = $.makeArray(arguments);
                args.unshift(source);
                return $.validator.format.apply(this, args);
            };
        }
        if (params === undef) {
            return source;
        }
        if (arguments.length > 2 && params.constructor !== Array) {
            params = $.makeArray(arguments).slice(1);
        }
        if (params.constructor !== Array) {
            params = [params];
        }
        $.each(params, function (i, n) {
            source = source.replace(new RegExp('\\{{' + i + '\\}}', 'g'), function () {
                return n;
            });
        });
        return source;
    }

    function kebabToCamel(string) {
        var firstLetter = string[0] || '';
        return firstLetter + string.slice(1).replace(/-\w/g, function (match) {
            return match[1].toUpperCase();
        });
    }

    function loadTemplate(template) {
        var version = RongWork.instance ? RongWork.instance.config.product.version : 'default';
        var promise;
        var pathRegex = new RegExp(/^([a-z_\-\s0-9./]+)+\.html$/);
        var isTemplateUrl = pathRegex.test(template);
        if (isTemplateUrl) {
            promise = $.get(template + '?v=' + version);
        } else {
            var html = $(template).html();
            promise = $.Deferred().resolve(html).promise();
        }
        return promise;
    }

    function asyncComponent(options, resolve, reject) {
        var promise = loadTemplate(options.template);
        promise.then(function (html) {
            options.mixins = options.mixins || [];
            var locale = {
                computed: {
                    locale: function () {
                        var localeInfo = RongWork.instance.locale;
                        var name = kebabToCamel(options.name);
                        return $.extend(true, {}, localeInfo, (localeInfo.components || {})[name]);
                    }
                },
                methods: {
                    localeFormat: templateFormat
                }
            };
            options.mixins.push(locale);
            var component = $.extend({}, options, {
                template: html
            });
            resolve(component);
        }).fail(function (xhr, status, error) {
            reject(error);
        });
    }

    function without(origin, out) {
        return origin.filter(function (item) {
            return out.indexOf(item) === -1;
        });
    }

    function watchHideDialog(context) {
        window.onhashchange = function () {
            context.close();
        };
    }
    // 增加一个弹出框
    function mountDialog(options, callback) {
        var templateSrc = options.template;
        if (mountDialog[templateSrc] === 'busy') {
            return;
        }
        mountDialog[templateSrc] = 'busy';
        var promise = loadTemplate(options.template);
        promise.then(function (html) {
            $.extend(options, {
                template: html
            });
            options.mixins = options.mixins || [];
            var locale = {
                mounted: function () {
                    var im = RongWork.instance;
                    var context = this;
                    context.imLogouted = function () {
                        context.$destroy();
                        $(context.$el).remove();
                        im.$off('imLogouted', context.imLogouted);
                    };
                    // 当页面有跳转的时候，关闭弹层
                    watchHideDialog(context);
                    im.$on('imLogouted', context.imLogouted);
                },
                computed: {
                    // 获取对应的相关文案
                    locale: function () {
                        var localeInfo = RongWork.instance.locale;
                        var name = kebabToCamel(options.name);
                        return $.extend(true, {}, localeInfo, localeInfo.components[name]);
                    }
                },
                methods: {
                    localeFormat: templateFormat
                }
            };
            options.mixins.push(locale);

            var Dialog = Vue.extend(options);
            var instance = new Dialog({
                el: document.createElement('div')
            });
            var wrap = RongWork.instance.$el.firstChild;
            $(wrap).append(instance.$el);
            if ($.isFunction(callback)) callback(instance);
        }).always(function () {
            delete mountDialog[templateSrc];
        });
    }

    /*
    说明：统一弹窗格式
    参数：
        @param {object}      params
        @param {string}      params.type          - 'confirm':有2个按钮的弹窗，'alert':有1个按钮的弹窗，默认为'alert'
        @param {string}      params.title         - 弹窗title，不传则为空
        @param {string}      params.message       - 弹窗内容，不传则为空
        @param {string}      params.submitText    - 确定按钮的文案
        @param {boolean}     params.isAlignLeft   - 弹窗内容不都左对齐
        @param {function}    params.closeCallback - 取消按钮回调函数
        @param {function}    params.callback      - 确认按钮回调函数
    */
    function messagebox(params) {
        var promise = loadTemplate('messagebox.html');
        promise.then(function (html) {
            var options = {
                name: 'messagebox',
                template: html,
                data: function () {
                    return {
                        type: params.type || 'alert',
                        title: params.title,
                        message: params.message,
                        submitText: params.submitText,
                        show: true,
                        isAlignLeft: params.isAlignLeft
                    };
                },
                created: function () {
                    var context = this;
                    var im = RongWork.instance;
                    context.title = params.title;
                    context.imLogined = function () {
                        context.close();
                        im.$off(context.imLogined);
                    };
                    im.$on('imlogined', context.imLogined);
                    im.$on('messageboxHide', context.close);
                    window.addEventListener('hashchange', context.close);
                },
                methods: {
                    close: function () {
                        if (params.closeCallback) params.closeCallback();
                        window.removeEventListener('hashchange', this.close);
                        this.show = false;
                    },
                    confirm: function () {
                        if (params.callback) params.callback();
                        this.show = false;
                    }
                },
                directives: {
                    autofocus: {
                        inserted: function (el) {
                            Vue.nextTick(function () {
                                el.focus();
                            });
                        }
                    }
                }
            };
            var locale = {
                computed: {
                    locale: function () {
                        var localeInfo = RongWork.instance.locale;
                        var name = kebabToCamel(options.name);
                        return $.extend(true, {}, localeInfo, (localeInfo.components || {})[name]);
                    }
                }
            };
            options.mixins = [locale];
            var Messagebox = Vue.extend(options);
            var instance = new Messagebox({
                el: document.createElement('div')
            });
            var wrap = RongWork.instance.$el.firstChild;
            $(wrap).append(instance.$el);
        });
    }
       //深拷贝
       function deepClone(obj){
        if (obj === null || typeof (obj) !== 'object' || 'isActiveClone' in obj)
          return obj;
      
        if (obj instanceof Date)
          var temp = new obj.constructor(); //or new Date(obj);
        else
          var temp = obj.constructor();
      
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            obj['isActiveClone'] = null;
            temp[key] = deepClone(obj[key]);
            delete obj['isActiveClone'];
          }
        }
        return temp;
      
}

    RongIM.utils = RongWork.utils = {
        messagebox: messagebox,
        mountDialog: mountDialog,
        without: without,
        appType: {
            base: 1, //融云的基础应用
            other: 2 //自定义应用
        },
        asyncComponent: asyncComponent,
        cache: cache,
        getQuerystr: getQuerystr,
        getQueryString: getQueryString
    };
}(window.RongIM, window.RongWork));