(function (RongWork) {
'use strict';

function noop() {}
window.openExternal = function(url) {
    var a = document.createElement('A');
    a.target = '_blank';
    a.href = url;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

RongWork.browserWindow = {
    max: noop,
    min: noop,
    restore: noop,
    close: noop,
    focus: noop,
    getPlatform: function () {
        return 'web';
    },
    enterPublic: noop,
    onEnterPublic: noop,
    onCommandClose: noop,
    onPublicNotify: noop,
    reloadWork: noop,
    openPSArticle: openExternal,
};
}(window.RongWork));
